/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandler;
import org.ujac.print.TagBuilder;
import org.ujac.print.TagInstantiationException;

public class CustomTagBuilder
implements TagBuilder {
    private String tagName;
    private String alias;
    private Map attributes;
    private Set aliases = null;

    public CustomTagBuilder(String tagName, String alias, Map attributes) {
        this.tagName = tagName;
        this.alias = alias;
        if (!attributes.containsKey("tagName")) {
            attributes.put("tagName", tagName);
        }
        this.attributes = attributes;
    }

    public String getName() {
        return this.alias;
    }

    public BaseDocumentTag createTag(DocumentHandler documentHandler) throws TagInstantiationException {
        BaseDocumentTag tag = documentHandler.getTagFactory().createTagInstance(documentHandler, this.tagName);
        tag.setCustomAttributes(this.attributes);
        return tag;
    }

    public void registerAlias(String alias) {
        if (this.aliases == null) {
            this.aliases = new HashSet();
        }
        this.aliases.add(alias);
    }

    public void unregisterAlias(String alias) {
        if (this.aliases == null) {
            return;
        }
        this.aliases.remove(alias);
    }

    public Collection getAliases() {
        return this.aliases;
    }
}

