/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BarcodeDatamatrix;
import java.util.HashMap;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.PhraseHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.util.exi.ExpressionException;

public class DatamatrixTag
extends BaseElementTag {
    private static final AttributeDefinition ENCODATION_TYPE = new AttributeDefinition("type", new String[]{"AUTO", "ASCII", "B256", "C40", "TEXT", "EDIFACT", "X21", "RAW"}, true, "The encodation type.");
    private static final AttributeDefinition WIDTH = new AttributeDefinition("width", 2, true, "The output width.");
    private static final AttributeDefinition HEIGHT = new AttributeDefinition("height", 2, true, "The output height.");
    private static final AttributeDefinition MATRIX_WIDTH = new AttributeDefinition("matrix-width", 2, false, "The datamatrix width.");
    private static final AttributeDefinition MATRIX_HEIGHT = new AttributeDefinition("matrix-height", 2, false, "The datamatrix height.");
    public static final String TAG_NAME = "datamatrix";
    private static Map barcodeTypes = null;
    private PhraseHolder phraseHolder = null;
    private String typeAttr = null;
    private float width = 0.0f;
    private float height = 0.0f;
    private int matrixWidth = 0;
    private int matrixHeight = 0;
    private int padding = 0;
    private boolean rotate = false;

    public DatamatrixTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Prints a datmatrix code.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(ENCODATION_TYPE).addDefinition(WIDTH).addDefinition(HEIGHT).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.ROTATE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(WIDTH).addDefinition(HEIGHT).addDefinition(CommonStyleAttributes.PADDING);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.phraseHolder = this.documentHandler.latestPhraseHolder();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.typeAttr = this.getStringAttribute(ENCODATION_TYPE, true, null);
        this.width = this.getDimensionAttribute(WIDTH, true, WIDTH);
        this.height = this.getDimensionAttribute(HEIGHT, true, HEIGHT);
        this.matrixWidth = this.getIntegerAttribute(MATRIX_WIDTH, true, null);
        this.matrixHeight = this.getIntegerAttribute(MATRIX_HEIGHT, true, null);
        this.padding = this.getIntegerAttribute(CommonAttributes.PADDING, true, CommonStyleAttributes.PADDING);
        this.rotate = this.getBooleanAttribute(CommonAttributes.ROTATE, true, null);
        String code = null;
        try {
            code = this.documentHandler.evalString(this.getTrimmedContent());
        }
        catch (ExpressionException ex) {
            throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
        }
        String typeString = null;
        try {
            typeString = this.documentHandler.evalString(this.typeAttr).toUpperCase();
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
        }
        Integer type = (Integer)barcodeTypes.get(typeString);
        if (type == null) {
            throw new TagAttributeException(this.locator(), "Unsupported datamatrix code type '" + typeString + "'.");
        }
        BarcodeDatamatrix dm = new BarcodeDatamatrix();
        dm.setOptions(type.intValue());
        if (this.matrixWidth > 0) {
            dm.setWidth(this.matrixWidth);
        }
        if (this.matrixHeight > 0) {
            dm.setHeight(this.matrixHeight);
        }
        dm.setWs(this.padding);
        ElementContainer elementContainer = this.getElementContainer();
        try {
            int result = dm.generate(code);
            switch (result) {
                case 1: {
                    throw new DocumentHandlerException(this.locator(), "Could not generate datamatrix code: The text is too big for the symbology capabilities.");
                }
                case 3: {
                    throw new DocumentHandlerException(this.locator(), "Could not generate datamatrix code: The dimensions given for the symbol are illegal.");
                }
                case 5: {
                    throw new DocumentHandlerException(this.locator(), "Could not generate datamatrix code: An error was while parsing an extension.");
                }
            }
            Image barcodeImage = dm.createImage();
            if (this.rotate) {
                barcodeImage.setRotation(1.5707964f);
            }
            barcodeImage.scaleAbsolute(this.width, this.height);
            if (this.phraseHolder != null) {
                this.phraseHolder.addChunk(this, new Chunk(barcodeImage, 0.0f, 0.0f));
            } else {
                elementContainer.addElement(this, (Element)barcodeImage);
            }
        }
        catch (DocumentHandlerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new TagAttributeException(this.locator(), "Creation of barcode '" + this.typeAttr + "' failed: " + ex.getMessage(), ex);
        }
    }

    static {
        barcodeTypes = new HashMap();
        barcodeTypes.put("AUTO", new Integer(0));
        barcodeTypes.put("ASCII", new Integer(1));
        barcodeTypes.put("B256", new Integer(4));
        barcodeTypes.put("C40", new Integer(2));
        barcodeTypes.put("TEXT", new Integer(3));
        barcodeTypes.put("EDIFACT", new Integer(6));
        barcodeTypes.put("X21", new Integer(5));
        barcodeTypes.put("RAW", new Integer(7));
    }
}

