/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.AddColumnTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TableHelper;

public class DefineTableTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "define-table";
    private String name = null;
    private Table table = null;

    public DefineTableTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a table and adds it to the document properties.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.TABLE_NAME);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(AddColumnTag.class, 0, 999));
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.name = this.getStringAttribute(CommonAttributes.TABLE_NAME, false, null);
        this.table = new DataTable(this.documentHandler.getFormatHelper());
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.documentHandler.getTemplateContext().setProperty(this.name, this.table);
    }

    public void defineColumn(String name, String type) throws TagAttributeException {
        try {
            int typeId = TableHelper.getColumnTypeId(type);
            this.table.addColumn(name, typeId);
        }
        catch (TableException ex) {
            throw new TagAttributeException(this.locator(), "Failed to define column '" + name + "': " + ex.getMessage(), ex);
        }
    }
}

