/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.Condition;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.FontHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.PrintRowTag;
import org.ujac.print.tag.PrintTableTag;
import org.ujac.print.tag.RowCellContainer;
import org.ujac.print.tag.RowCellTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.util.table.Column;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;

public class ExtraRowTag
extends BaseDocumentTag
implements FontHolder,
Condition,
RowCellContainer,
StyleHolder {
    private static final AttributeDefinition DIRECTION = new AttributeDefinition("direction", 12, false, "The insert direction: 'before' | 'after'.");
    private static final AttributeDefinition CELL_ROTATE = CommonAttributes.ROTATE.cloneAttrDef("The rotation angle for all cells of the row.");
    public static final String TAG_NAME = "extra-row";
    protected PrintTableTag rowContainer = null;
    private PrintRowTag printRowTag = null;
    private CellAttributes cellAttributes = null;
    protected float rotate = 0.0f;
    protected RowCellTag[] cellStyles = null;

    public ExtraRowTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds an extra row to the surrounding &lt;print-row&gt; tag.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(DIRECTION).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.BORDER_STYLE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.PADDING_LEFT).addDefinition(CommonAttributes.PADDING_RIGHT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(CommonAttributes.PADDING_BOTTOM).addDefinition(CommonAttributes.NO_WRAP).addDefinition(CommonAttributes.CELL_HEIGHT).addDefinition(CommonAttributes.ROTATE).addDefinition(CELL_ROTATE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.BORDER_STYLE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_LEFT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_RIGHT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_TOP_WIDTH).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR).addDefinition(CommonStyleAttributes.BORDER_LEFT_COLOR).addDefinition(CommonStyleAttributes.BORDER_RIGHT_COLOR).addDefinition(CommonStyleAttributes.BORDER_TOP_COLOR).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_COLOR).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.PADDING).addDefinition(CommonStyleAttributes.PADDING_LEFT).addDefinition(CommonStyleAttributes.PADDING_RIGHT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).addDefinition(CommonStyleAttributes.CELL_HEIGHT).addDefinition(CommonStyleAttributes.ROTATE).addDefinition(CommonStyleAttributes.NO_WRAP);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(RowCellTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.rowContainer = (PrintTableTag)this.documentHandler.latestOfType(PrintTableTag.class);
        this.printRowTag = (PrintRowTag)this.documentHandler.latestOfType(PrintRowTag.class);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.cellAttributes = new CellAttributes(this.getCommonAttributesHolder());
        this.cellAttributes.parseRowAttributes(this, this.rowContainer.getCellAttributes());
        this.rotate = this.getFloatAttribute(CommonAttributes.ROTATE, 0.0f, true, CommonStyleAttributes.ROTATE);
        this.cellStyles = new RowCellTag[this.rowContainer.getNumColumns()];
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        String strDirection = this.getStringAttribute(DIRECTION, "after", true, DIRECTION).toLowerCase();
        int direction = 2;
        if ("before".equals(strDirection)) {
            direction = 1;
        }
        this.printRowTag.insertExtraRow(this, direction);
    }

    public void outputRow() throws DocumentHandlerException {
        Row currentRow = (Row)this.rowContainer.getCurrentValue();
        try {
            Column[] columns = this.rowContainer.getVisibleColumns();
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                int columnIdx = column.getIndex();
                int colspan = 1;
                boolean fillRow = false;
                CellAttributes attrs = (CellAttributes)this.cellAttributes.clone();
                int hAlign = -1;
                if (columnIdx != -1) {
                    switch (currentRow.getAlign(columnIdx)) {
                        case 0: {
                            hAlign = 0;
                            break;
                        }
                        case 2: {
                            hAlign = 2;
                            break;
                        }
                        case 1: {
                            hAlign = 1;
                            break;
                        }
                        default: {
                            hAlign = 0;
                        }
                    }
                }
                attrs.setHAlign(hAlign);
                DocumentFont font = this.getFont();
                PdfPCell cell = null;
                RowCellTag rowCell = this.cellStyles[i];
                if (rowCell != null) {
                    CellAttributes rowCellAttributes = rowCell.getCellAttributes();
                    attrs.merge(rowCellAttributes);
                    if (rowCell.getCell() != null) {
                        cell = rowCell.getCell();
                        colspan = cell.getColspan();
                        fillRow = rowCellAttributes.isFillRow();
                        if (fillRow) {
                            colspan = this.rowContainer.getRemainingPdfColumns();
                        }
                        attrs.setColspan(colspan);
                        attrs.setupCell(cell);
                    } else {
                        colspan = rowCellAttributes.getColspan();
                        fillRow = rowCellAttributes.isFillRow();
                        if (fillRow) {
                            colspan = this.rowContainer.getRemainingPdfColumns();
                        }
                        font = rowCell.getFont();
                        this.rotate = rowCell.getRotate();
                    }
                }
                if (cell == null) {
                    Phrase cellPhrase = new Phrase("", font.getFont());
                    if (this.rotate != 0.0f) {
                        cellPhrase = this.rotatePhrase(cellPhrase, this.rotate);
                    }
                    cell = new PdfPCell(cellPhrase);
                    attrs.setLeading(0.0f);
                    attrs.setColspan(colspan);
                    attrs.setupCell(cell);
                }
                if (colspan > 1) {
                    i += colspan - 1;
                }
                if (this.isHeaderRow()) {
                    this.rowContainer.addHeaderCell(this, cell);
                    continue;
                }
                this.rowContainer.addCell(this, cell);
            }
        }
        catch (TableException ex) {
            throw new DocumentHandlerException(this.locator(), "Failed to access table cell: " + ex.getMessage(), ex);
        }
    }

    public void registerRowCell(RowCellTag rowCell) {
        int index = rowCell.getColumnIndex();
        if (index < 0) {
            index = this.rowContainer.getColumnIndex(rowCell.getColumnName());
        }
        this.cellStyles[index] = rowCell;
    }

    public boolean isTrue() {
        return this.condition != null ? this.condition.isTrue() && this.printRowTag.isTrue() : this.printRowTag.isTrue();
    }

    protected boolean isHeaderRow() {
        return this.printRowTag.isHeaderRow();
    }

    public CellAttributes getCellAttributes() {
        return this.cellAttributes;
    }
}

