/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.CellContainer;
import org.ujac.print.Condition;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.PdfCellContainer;
import org.ujac.print.PdfTableHolder;
import org.ujac.print.PhraseHolder;
import org.ujac.print.tag.BaseLoopTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.util.template.TemplateException;

public class ForeachTag
extends BaseLoopTag
implements Condition,
ElementContainer,
CellContainer,
PdfCellContainer,
PhraseHolder {
    public static final String TAG_NAME = "foreach";
    protected CellContainer cellContainer = null;
    protected PdfCellContainer pdfCellContainer = null;
    protected PhraseHolder phraseHolder = null;
    protected Phrase phrase = null;
    protected boolean childsAdded = false;

    public ForeachTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Executes the nested items for each occurrence of the specified sequence. Sequences can be everything that provides an iterator method serving an Iterator instance.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.LOOP_VARIABLE).addDefinition(CommonAttributes.SEQUENCE).addDefinition(CommonAttributes.TRIM_BODY);
    }

    public boolean isVirtualContainer() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.cellContainer = this.documentHandler.latestCellContainer();
        this.pdfCellContainer = this.documentHandler.latestPdfCellContainer();
        this.phraseHolder = this.documentHandler.latestPhraseHolder();
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (this.isTrue()) {
            this.flushContent();
            ElementContainer elementContainer = this.getElementContainer();
            elementContainer.addElement(item, element);
            this.childsAdded = true;
        }
    }

    public boolean isTopLevel() {
        ElementContainer elementContainer = this.getElementContainer();
        return elementContainer.isTopLevel();
    }

    public void addCell(BaseDocumentTag item, Cell cell) throws DocumentHandlerException {
        if (this.isTrue()) {
            this.cellContainer.addCell(item, cell);
            this.childsAdded = true;
        }
    }

    public int getRemainingColumns() {
        return this.cellContainer.getRemainingColumns();
    }

    public void addCell(BaseDocumentTag item, PdfPCell cell) throws DocumentHandlerException {
        if (this.isTrue()) {
            this.pdfCellContainer.addCell(item, cell);
            this.childsAdded = true;
        }
    }

    public int getRemainingPdfColumns() {
        return this.pdfCellContainer.getRemainingPdfColumns();
    }

    public PdfTableHolder getPdfTable() {
        return this.pdfCellContainer.getPdfTable();
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (this.phraseHolder == null) {
            return;
        }
        this.phraseHolder.addChunk(item, chunk, font);
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) throws DocumentHandlerException {
        if (this.phraseHolder == null) {
            return;
        }
        this.phraseHolder.addChunk(item, chunk);
    }

    public float getLeading() {
        if (this.phraseHolder == null) {
            return 0.0f;
        }
        return this.phraseHolder.getLeading();
    }

    public float getLineSpacing() {
        if (this.phraseHolder == null) {
            ElementContainer elementContainer = this.getElementContainer();
            if (elementContainer == null) {
                return 1.2f;
            }
            return elementContainer.getLineSpacing();
        }
        return this.phraseHolder.getLineSpacing();
    }

    public void flushContent() throws DocumentHandlerException {
        if (!this.isTrue()) {
            return;
        }
        if (this.phraseHolder != null && this.phrase == null) {
            this.phrase = new Phrase(0.0f);
        }
        if (this.isIgnoreFlush()) {
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if (this.phraseHolder != null) {
            if (this.content == null) {
                return;
            }
            try {
                String content = this.documentHandler.executeTemplate(this.getContent());
                this.phraseHolder.addChunk(this, content, this.getFont());
            }
            catch (TemplateException ex) {
                throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
            }
        } else {
            Phrase nestedPhrase = this.addChunk(this.phrase, this.getLeading(), this.getLineSpacing());
            if (nestedPhrase != null) {
                this.phrase = nestedPhrase;
            }
        }
        this.resetContent();
    }

    public CellContainer getCellContainer() {
        return this.cellContainer;
    }

    public PdfCellContainer getPdfCellContainer() {
        return this.pdfCellContainer;
    }

    public CellAttributes getCellAttributes() {
        if (this.cellContainer != null) {
            return this.pdfCellContainer.getCellAttributes();
        }
        if (this.pdfCellContainer != null) {
            return this.pdfCellContainer.getCellAttributes();
        }
        return null;
    }
}

