/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.ConditionTag;
import org.ujac.util.exi.ExpressionException;

public class IfTag
extends ConditionTag {
    public static final String TAG_NAME = "if";
    private String condition = null;

    public IfTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Conditional item, which evalutes its content in case the specified condition evaluates to true.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CONDITION);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.condition = this.getStringAttribute(CommonAttributes.CONDITION, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            this.result = false;
            return;
        }
        try {
            this.result = this.documentHandler.evalBoolean(this.condition);
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
        }
    }
}

