/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.JavascriptContainer;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.util.template.TemplateException;

public class JavascriptTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "javascript";

    public JavascriptTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds javascript code to the surrounding element.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        String code = this.getContent();
        try {
            code = this.documentHandler.executeTemplate(code);
            JavascriptContainer javascriptContainer = (JavascriptContainer)((Object)this.documentHandler.latestOfType(JavascriptContainer.class));
            if (javascriptContainer == null) {
                throw new DocumentHandlerException(this.locator(), "Unable to locate javascript container.");
            }
            PdfWriter pdfWriter = (PdfWriter)this.documentHandler.getDocumentWriter();
            pdfWriter.addJavaScript(code);
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Failed to evaluate script code: '" + code + "': " + ex.getMessage(), ex);
        }
    }
}

