/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import java.util.ArrayList;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.PhraseHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ListTag;
import org.ujac.util.template.TemplateException;

public class ListSymbolTag
extends BaseElementTag
implements ElementContainer,
PhraseHolder {
    public static final String TAG_NAME = "list-symbol";
    private ListTag listTag = null;
    private Chunk nestedChunk = null;

    public ListSymbolTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Specifies the list symbol at the surroundng list.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return null;
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(ImageTag.class, 0, 1));
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.listTag = (ListTag)this.documentHandler.latestOfType(ListTag.class);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        Chunk listSymbol = this.nestedChunk;
        if (listSymbol == null) {
            Phrase symbolPhrase;
            ArrayList symbolChunks;
            int numSymbolChunks;
            String symbol = null;
            try {
                symbol = this.getDocumentHandler().executeTemplate(this.getContent());
            }
            catch (TemplateException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
            if (symbol == null) {
                symbol = "";
            }
            if ((numSymbolChunks = (symbolChunks = (symbolPhrase = this.addChunk(this, new Phrase(0.0f), symbol, this.getFont(), this.getLeading(), this.getLineSpacing())).getChunks()).size()) >= 1) {
                listSymbol = (Chunk)symbolChunks.get(0);
            } else {
                throw new DocumentHandlerException(this.locator(), "No list symbol found.");
            }
        }
        this.listTag.setListSymbol(listSymbol);
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (element instanceof Image) {
            this.nestedChunk = new Chunk((Image)element, 0.0f, 0.0f);
            return;
        }
        if (!(element instanceof Chunk)) {
            throw new DocumentHandlerException(this.locator(), "Only images are allowed within list-symbol tag.");
        }
        this.nestedChunk = (Chunk)element;
    }

    public boolean isTopLevel() {
        return false;
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        this.nestedChunk = new Chunk(chunk, font.getFont());
        float textRise = font.getTextRise();
        if (textRise != 0.0f) {
            this.nestedChunk.setTextRise(textRise);
        }
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) {
        this.nestedChunk = chunk;
    }

    public float getLeading() {
        return 0.0f;
    }

    public float getLineSpacing() {
        return this.listTag.getLineSpacing();
    }
}

