/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.CellContainer;
import org.ujac.print.Condition;
import org.ujac.print.DocumentEvent;
import org.ujac.print.DocumentEventRecorder;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.ParameterDefHolder;
import org.ujac.print.ParameterDefinition;
import org.ujac.print.PdfCellContainer;
import org.ujac.print.PdfTableHolder;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CustomTagBuilder;
import org.ujac.print.tag.ParameterDefTag;

public class MacroDefTag
extends BaseDocumentTag
implements ParameterDefHolder,
DocumentEventRecorder,
CellContainer,
PdfCellContainer,
ElementContainer,
Condition {
    private static final AttributeDefinition MACRO_NAME = new AttributeDefinition("name", 4, true, "The name of the macro to define.");
    public static final String TAG_NAME = "macro-def";
    protected String name = null;
    private Map parameterDefs = null;
    private List documentEvents = new ArrayList();

    public MacroDefTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a document macro block. This macro can be used in serveral parts of the document using the 'macro' item.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(MACRO_NAME);
    }

    public boolean isVirtualContainer() {
        return true;
    }

    public List getDocumentEvents() {
        return this.documentEvents;
    }

    public Map getParameterDefs() {
        return this.parameterDefs;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        if (this.isAttributeSupported(MACRO_NAME)) {
            this.name = this.getStringAttribute(MACRO_NAME, false, null);
        }
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.documentHandler.pushEventRecorder(this);
        if (!this.isValid()) {
            return;
        }
        this.parameterDefs = new HashMap();
    }

    public void closeItem() throws DocumentHandlerException {
        this.documentHandler.popEventRecorder();
        if (!this.isValid()) {
            return;
        }
        this.documentHandler.registerMacroDefinition(this.name, this);
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        customAttributes.put("name", this.name);
        this.documentHandler.getTagFactory().registerTag(this.name, new CustomTagBuilder("macro", this.name, customAttributes));
    }

    public void setParameterDef(ParameterDefinition parameterDef) {
        this.parameterDefs.put(parameterDef.getName(), parameterDef);
    }

    public void recordEvent(DocumentEvent event) {
        BaseDocumentTag item = event.getItem();
        if (item != this && !(item instanceof ParameterDefTag)) {
            this.documentEvents.add(event);
        }
    }

    public void addCell(BaseDocumentTag item, Cell cell) throws DocumentHandlerException {
    }

    public int getRemainingColumns() {
        return 0;
    }

    public void addCell(BaseDocumentTag item, PdfPCell cell) throws DocumentHandlerException {
    }

    public int getRemainingPdfColumns() {
        return 0;
    }

    public PdfTableHolder getPdfTable() {
        return null;
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
    }

    public boolean isTopLevel() {
        return false;
    }

    public float getLineSpacing() {
        return 1.2f;
    }

    public float getLeading() {
        return 0.0f;
    }

    public boolean isTrue() {
        return false;
    }

    public CellAttributes getCellAttributes() {
        return null;
    }
}

