/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPageEventHandler;
import org.ujac.print.OutlineItem;
import org.ujac.print.PdfHelper;
import org.ujac.print.TagAttributeException;
import org.ujac.print.TocItem;
import org.ujac.print.tag.BaseCellTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.util.BeanUtils;
import org.ujac.util.template.TemplateException;

public class OutlineTag
extends BaseDocumentTag
implements PdfPCellEvent {
    private static final AttributeDefinition NAME = CommonAttributes.NAME.cloneAttrDef("The name of the outline, needed to link outlines with each other and to build anchors which can be referenced from TOC.").setRequired(false);
    private static final AttributeDefinition PARENT = new AttributeDefinition("parent", 12, false, "The name of the parent outline.");
    private static final AttributeDefinition X = new AttributeDefinition("x", 14, false, "The absolute horizontal position to jump to.");
    private static final AttributeDefinition Y = new AttributeDefinition("y", 14, false, "The absolute horizontal position to jump to.");
    private static final AttributeDefinition TOC_NUMBER = new AttributeDefinition("toc-number", 4, false, "The number to view in the table of contents.");
    public static final String TAG_NAME = "outline";
    protected BaseDocumentTag parentTag = null;
    private String tocNumber = null;
    private String tocRelevance = null;

    public OutlineTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a outline to the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(NAME).addDefinition(PARENT).addDefinition(X).addDefinition(Y).addDefinition(TOC_NUMBER).addDefinition(CommonAttributes.TOC_RELEVANCE);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.parentTag = this.documentHandler.latestRealTag();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.tocNumber = this.getStringAttribute(TOC_NUMBER, null, true, null);
        this.tocRelevance = this.getStringAttribute(CommonAttributes.TOC_RELEVANCE, true, CommonStyleAttributes.TOC_RELEVANCE);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.parentTag instanceof BaseCellTag) {
            ((BaseCellTag)this.parentTag).addCellEventHandler(this);
            return;
        }
        if (this.parentTag instanceof ParagraphTag) {
            this.documentHandler.setPageEventHandler(this.parentTag, (PdfPageEvent)new OutlinePageEventHandler());
            return;
        }
        try {
            Document document = this.getDocumentHandler().getDocument();
            PdfWriter pdfWriter = (PdfWriter)this.getDocumentHandler().getDocumentWriter();
            float y = 0.0f;
            y = this.isAttributeDefined(Y) ? this.getDimensionAttribute(Y, true, null) : PdfHelper.getCurrentVerticalPosition(pdfWriter) + document.bottomMargin() + document.bottom();
            this.createOutline(y);
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to create outline: " + ex.getMessage(), ex);
        }
    }

    protected void createOutline(float y) throws DocumentHandlerException {
        PdfWriter pdfWriter = (PdfWriter)this.getDocumentHandler().getDocumentWriter();
        PdfContentByte cb = pdfWriter.getDirectContent();
        PdfOutline parent = cb.getRootOutline();
        if (this.isAttributeDefined(PARENT)) {
            parent = this.findOutline(parent, this.getStringAttribute(PARENT, true, null));
        }
        PdfDestination destination = null;
        float x = 0.0f;
        if (this.isAttributeDefined(X)) {
            x = this.getDimensionAttribute(X, true, null);
            destination = new PdfDestination(0, x, y, 0.0f);
        } else {
            destination = new PdfDestination(2, y);
        }
        String title = null;
        try {
            title = this.documentHandler.executeTemplate(this.getContent());
        }
        catch (TemplateException ex) {
            throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
        }
        PdfOutline outline = new PdfOutline(parent, destination, title);
        String name = null;
        if (this.isAttributeDefined(NAME)) {
            name = this.getStringAttribute(NAME, true, null);
            outline.setTag(name);
            if (this.documentHandler.isDestinationsSupported()) {
                cb.addOutline(outline, name);
                cb.localDestination(name, destination);
            }
        }
        OutlineItem outlineItem = new OutlineItem(name, this.documentHandler.getPageNumber(pdfWriter), x, y, parent.getTag(), title);
        this.documentHandler.addOutline(outlineItem);
        if (this.tocNumber != null || this.tocRelevance != null) {
            if (!BeanUtils.equals(this.tocRelevance, "index") && this.tocNumber == null) {
                throw new TagAttributeException(this.locator(), "In case toc relevance includes table of contents, the attribute 'toc-number' has to be defined for tag 'outline'.");
            }
            TocItem tocItem = new TocItem(1, this.tocNumber, title, this.tocRelevance != null ? this.tocRelevance : "all", this.documentHandler.getPageNumber(pdfWriter), y);
            tocItem.setOutline(outlineItem);
            this.documentHandler.addTocItem(tocItem);
        }
    }

    private PdfOutline findOutline(PdfOutline rootOutline, String name) {
        String tag = rootOutline.getTag();
        if (tag != null && tag.equals(name)) {
            return rootOutline;
        }
        ArrayList childs = rootOutline.getKids();
        if (childs == null) {
            return null;
        }
        int numChilds = childs.size();
        for (int i = 0; i < numChilds; ++i) {
            PdfOutline result = this.findOutline((PdfOutline)childs.get(i), name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
        try {
            this.createOutline(position.getTop());
        }
        catch (DocumentHandlerException ex) {
            ex.printStackTrace();
        }
    }

    public class OutlinePageEventHandler
    extends DocumentPageEventHandler {
        private boolean outlineCreated = false;

        public boolean isTemporary() {
            return true;
        }

        public void onParagraph(PdfWriter writer, Document document, float position) {
            if (!this.outlineCreated && OutlineTag.this.parentTag instanceof ParagraphTag) {
                try {
                    OutlineTag.this.createOutline(position);
                    this.outlineCreated = true;
                }
                catch (DocumentHandlerException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

