/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;

public class OverlayTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "overlay";
    private static final AttributeDefinition IMAGE_SOURCE = CommonAttributes.IMAGE_SOURCE.cloneAttrDef("The location of the document to overlay at resource loader.");
    private static final AttributeDefinition IMAGE_PAGE = CommonAttributes.IMAGE_PAGE.cloneAttrDef("The number of the page from the source document to overlay, defaults to 1.");
    private static final AttributeDefinition IMAGE_X = CommonAttributes.IMAGE_X.cloneAttrDef("The horizontal offset for the overlayed PDF. If not defined, the left margin defines the offset.");
    private static final AttributeDefinition IMAGE_X_STYLE = CommonStyleAttributes.IMAGE_X.cloneAttrDef("The horizontal offset for the overlayed PDF. If not defined, the left margin defines the offset.");
    private static final AttributeDefinition IMAGE_Y = CommonAttributes.IMAGE_Y.cloneAttrDef("The vertical offset for the overlayed PDF. If not defined, the bottom margin defines the offset.");
    private static final AttributeDefinition IMAGE_Y_STYLE = CommonStyleAttributes.IMAGE_Y.cloneAttrDef("The vertical offset for the overlayed PDF. If not defined, the bottom margin defines the offset.");
    private Object source = null;
    private int page = 0;

    public OverlayTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Places the contents of the specified PDF source as the background of the document. This contents will get overlayed by the output of the following tags.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(IMAGE_SOURCE).addDefinition(IMAGE_PAGE).addDefinition(IMAGE_X).addDefinition(IMAGE_Y).addDefinition(CommonAttributes.PAGE_ROTATE).addDefinition(CommonAttributes.MARGIN_LEFT).addDefinition(CommonAttributes.MARGIN_RIGHT).addDefinition(CommonAttributes.MARGIN_TOP).addDefinition(CommonAttributes.MARGIN_BOTTOM);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(IMAGE_X_STYLE).addDefinition(IMAGE_Y_STYLE).addDefinition(CommonAttributes.PAGE_ROTATE).addDefinition(CommonAttributes.MARGIN_LEFT).addDefinition(CommonAttributes.MARGIN_RIGHT).addDefinition(CommonAttributes.MARGIN_TOP).addDefinition(CommonAttributes.MARGIN_BOTTOM);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.source = this.getStringAttribute(CommonAttributes.IMAGE_SOURCE, true, null);
        this.page = this.getIntegerAttribute(CommonAttributes.IMAGE_PAGE, 1, true, null);
        String rotateAttr = this.getStringAttribute(CommonAttributes.IMAGE_ROTATE, true, CommonStyleAttributes.IMAGE_ROTATE);
        boolean rotate = false;
        if (rotateAttr != null) {
            rotate = new Boolean(rotateAttr);
        }
        byte[] content = null;
        try {
            float margin;
            content = this.source instanceof byte[] ? (byte[])this.source : this.documentHandler.loadResource(this.source.toString());
            PdfWriter writer = (PdfWriter)this.documentHandler.getDocumentWriter();
            PdfReader reader = new PdfReader(content);
            if (this.page < 0) {
                throw new DocumentHandlerException(this.locator(), "The page number must be 1 at least!");
            }
            PdfImportedPage importedPage = writer.getImportedPage(reader, this.page);
            Rectangle bbox = importedPage.getBoundingBox();
            Rectangle oldBox = new Rectangle(bbox);
            if (this.isAttributeDefined(CommonAttributes.MARGIN_LEFT, CommonStyleAttributes.MARGIN_LEFT)) {
                margin = this.getDimensionAttribute(CommonAttributes.MARGIN_LEFT, true, CommonStyleAttributes.MARGIN_LEFT);
                bbox.setLeft(margin);
            }
            if (this.isAttributeDefined(CommonAttributes.MARGIN_RIGHT, CommonStyleAttributes.MARGIN_RIGHT)) {
                margin = this.getDimensionAttribute(CommonAttributes.MARGIN_RIGHT, true, CommonStyleAttributes.MARGIN_RIGHT);
                bbox.setRight(oldBox.getRight() - margin);
            }
            if (this.isAttributeDefined(CommonAttributes.MARGIN_BOTTOM, CommonStyleAttributes.MARGIN_BOTTOM)) {
                margin = this.getDimensionAttribute(CommonAttributes.MARGIN_BOTTOM, true, CommonStyleAttributes.MARGIN_BOTTOM);
                bbox.setBottom(margin);
            }
            if (this.isAttributeDefined(CommonAttributes.MARGIN_TOP, CommonStyleAttributes.MARGIN_TOP)) {
                margin = this.getDimensionAttribute(CommonAttributes.MARGIN_TOP, true, CommonStyleAttributes.MARGIN_TOP);
                bbox.setTop(oldBox.getTop() - margin);
            }
            importedPage.setBoundingBox(bbox);
            float left = bbox.getLeft() * -1.0f;
            float bottom = bbox.getBottom() * -1.0f;
            if (rotate) {
                importedPage.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, oldBox.getHeight(), 0.0f);
                left *= -1.0f;
            }
            if (this.isAttributeDefined(CommonAttributes.IMAGE_X, CommonStyleAttributes.IMAGE_X)) {
                left = this.getFloatAttribute(CommonAttributes.IMAGE_X, true, CommonStyleAttributes.IMAGE_X);
            }
            if (this.isAttributeDefined(CommonAttributes.IMAGE_Y, CommonStyleAttributes.IMAGE_Y)) {
                bottom = this.getFloatAttribute(CommonAttributes.IMAGE_Y, true, CommonStyleAttributes.IMAGE_Y);
            }
            writer.getDirectContentUnder().addTemplate((PdfTemplate)importedPage, left, bottom);
        }
        catch (IllegalArgumentException ex) {
            throw new DocumentHandlerException(this.locator(), "The page #" + this.page + " could not be loaded from document " + this.source + "'.", ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to load overlay document from location '" + this.source + "': " + ex.getMessage(), ex);
        }
    }

    public void closeItem() throws DocumentHandlerException {
    }
}

