/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.pdf.PdfPCell;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.PdfCellContainer;
import org.ujac.print.tag.BaseCellTag;
import org.ujac.print.tag.CellAttributes;

public class PdfCellTag
extends BaseCellTag {
    public static final String TAG_NAME = "cell";
    private PdfCellContainer cellContainer = null;

    public PdfCellTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a cell to its surrounding table or surrounding cell.";
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.cellContainer = this.documentHandler.latestPdfCellContainer();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        if (this.fillRow) {
            this.colspan = this.cellContainer.getRemainingPdfColumns();
        }
    }

    protected CellAttributes getParentAttributes() {
        return this.cellContainer.getCellAttributes();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        super.closeItem();
        this.itemClosed = true;
        PdfPCell cell = this.getCell();
        if (cell == null) {
            cell = this.buildCell();
        }
        this.cellContainer.addCell(this, cell);
    }
}

