/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.PdfTableTag;

public class PdfTableSplitTag
extends BaseDocumentTag {
    private static final AttributeDefinition NEW_PAGE = new AttributeDefinition("new-page", 3, false, "Flag telling whether to add a page break before continuing the table or not.");
    private static final AttributeDefinition KEEP_HEADER = new AttributeDefinition("keep-header", 3, false, "Flag telling whether to keep the currently defined header of the table or to reset the header.");
    public static final String TAG_NAME = "table-split";
    private PdfTableTag tableItem = null;
    private boolean newPage = false;
    private boolean keepHeader = false;

    public PdfTableSplitTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Splits the surrounding table. This can be useful, if you like to break up a table or want to continue the table on the next page.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(NEW_PAGE).addDefinition(KEEP_HEADER);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.tableItem = (PdfTableTag)this.documentHandler.latestOfType("table");
        this.newPage = this.getBooleanAttribute(NEW_PAGE, false, null);
        this.keepHeader = this.getBooleanAttribute(KEEP_HEADER, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.tableItem.splitTable(this.newPage, this.keepHeader);
    }

    public void closeItem() throws DocumentHandlerException {
    }
}

