/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.Condition;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.FontHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ExtraRowTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.PrintTableTag;
import org.ujac.print.tag.RowCellContainer;
import org.ujac.print.tag.RowCellTag;
import org.ujac.print.tag.SetPropertyTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TogglePropertyTag;
import org.ujac.util.BeanUtils;
import org.ujac.util.table.Column;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;
import org.ujac.util.template.TemplateException;
import org.ujac.util.text.FormatHelper;

public class PrintRowTag
extends BaseDocumentTag
implements FontHolder,
Condition,
RowCellContainer,
StyleHolder {
    public static final String TAG_NAME = "print-row";
    protected PrintTableTag rowContainer = null;
    private CellAttributes cellAttributes = null;
    protected float rotate = 0.0f;
    protected RowCellTag[] registeredRowCells = null;
    protected List extraRowsBefore = null;
    protected List extraRowsAfter = null;

    public PrintRowTag() {
        super(TAG_NAME);
    }

    public PrintRowTag(String name) {
        super(name);
    }

    public String getDescription() {
        return "Prints the contents of normal table rows.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.BORDER_STYLE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.PADDING_LEFT).addDefinition(CommonAttributes.PADDING_RIGHT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(CommonAttributes.PADDING_BOTTOM).addDefinition(CommonAttributes.CELL_HEIGHT).addDefinition(CommonAttributes.ROTATE).addDefinition(CommonAttributes.NO_WRAP);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.BORDER_STYLE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_LEFT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_RIGHT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_TOP_WIDTH).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR).addDefinition(CommonStyleAttributes.BORDER_LEFT_COLOR).addDefinition(CommonStyleAttributes.BORDER_RIGHT_COLOR).addDefinition(CommonStyleAttributes.BORDER_TOP_COLOR).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_COLOR).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.PADDING).addDefinition(CommonStyleAttributes.PADDING_LEFT).addDefinition(CommonStyleAttributes.PADDING_RIGHT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).addDefinition(CommonStyleAttributes.CELL_HEIGHT).addDefinition(CommonStyleAttributes.ROTATE).addDefinition(CommonStyleAttributes.NO_WRAP);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(ExtraRowTag.class, 0, 999)).addDefinition(new ChildDefinition(RowCellTag.class, 0, 999)).addDefinition(new ChildDefinition(SetPropertyTag.class, 0, 999)).addDefinition(new ChildDefinition(TogglePropertyTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.rowContainer = (PrintTableTag)this.documentHandler.latestOfType(PrintTableTag.class);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.cellAttributes = new CellAttributes(this.getCommonAttributesHolder());
        this.cellAttributes.parseRowAttributes(this, this.rowContainer.getCellAttributes());
        this.rotate = this.getFloatAttribute(CommonAttributes.ROTATE, 0.0f, true, CommonStyleAttributes.ROTATE);
        this.registeredRowCells = new RowCellTag[this.rowContainer.getNumColumns()];
        this.extraRowsBefore = null;
        this.extraRowsAfter = null;
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.isTrue()) {
            ExtraRowTag extraRow;
            int i;
            int numExtraRows;
            List extraRows;
            Row currentRow = (Row)this.rowContainer.getCurrentValue();
            if (this.extraRowsBefore != null) {
                extraRows = this.extraRowsBefore;
                numExtraRows = extraRows.size();
                for (i = 0; i < numExtraRows; ++i) {
                    extraRow = (ExtraRowTag)extraRows.get(i);
                    extraRow.outputRow();
                }
            }
            this.outputRow(currentRow);
            if (this.extraRowsAfter != null) {
                extraRows = this.extraRowsAfter;
                numExtraRows = extraRows.size();
                for (i = 0; i < numExtraRows; ++i) {
                    extraRow = (ExtraRowTag)extraRows.get(i);
                    extraRow.outputRow();
                }
            }
        }
    }

    public void insertExtraRow(ExtraRowTag extraRow, int insertDirection) {
        List extraRowList = null;
        if (insertDirection == 1) {
            if (this.extraRowsBefore == null) {
                this.extraRowsBefore = new ArrayList();
            }
            extraRowList = this.extraRowsBefore;
        } else {
            if (this.extraRowsAfter == null) {
                this.extraRowsAfter = new ArrayList();
            }
            extraRowList = this.extraRowsAfter;
        }
        extraRowList.add(extraRow);
    }

    public void outputRow(Row currentRow) throws DocumentHandlerException {
        try {
            Column[] columns = this.rowContainer.getVisibleColumns();
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                int columnIdx = column.getIndex();
                int colspan = 1;
                boolean fillRow = false;
                CellAttributes attrs = (CellAttributes)this.cellAttributes.clone();
                int hAlign = -1;
                if (columnIdx != -1) {
                    switch (currentRow.getAlign(columnIdx)) {
                        case 0: {
                            hAlign = 0;
                            break;
                        }
                        case 2: {
                            hAlign = 2;
                            break;
                        }
                        case 1: {
                            hAlign = 1;
                            break;
                        }
                        default: {
                            hAlign = 0;
                        }
                    }
                }
                attrs.setHAlign(hAlign);
                DocumentFont font = this.getFont();
                float rotate = this.rotate;
                String formatString = null;
                PdfPCell cell = null;
                RowCellTag rowCell = this.registeredRowCells[i];
                if (rowCell != null) {
                    CellAttributes rowCellAttributes = rowCell.getCellAttributes();
                    attrs.merge(rowCellAttributes);
                    if (rowCell.getCell() != null) {
                        cell = rowCell.getCell();
                        colspan = cell.getColspan();
                        fillRow = rowCellAttributes.isFillRow();
                        if (fillRow) {
                            colspan = this.rowContainer.getRemainingPdfColumns();
                        }
                        attrs.setColspan(colspan);
                        attrs.setupCell(cell);
                    } else {
                        colspan = rowCellAttributes.getColspan();
                        fillRow = rowCellAttributes.isFillRow();
                        if (fillRow) {
                            colspan = this.rowContainer.getRemainingPdfColumns();
                        }
                        font = rowCell.getFont();
                        formatString = rowCell.getFormat();
                        rotate = rowCell.getRotate();
                    }
                }
                if (cell == null) {
                    String defaultContent;
                    String cellContent = null;
                    if (columnIdx != -1 && currentRow.isVisible(columnIdx)) {
                        if (formatString == null) {
                            defaultContent = null;
                            if (this.isHeaderRow()) {
                                if (column != null) {
                                    defaultContent = column.getLayoutHints().getHeader();
                                }
                            } else {
                                defaultContent = this.rowContainer.getDefaultContent(i);
                            }
                            if (!BeanUtils.isEmpty(defaultContent)) {
                                try {
                                    cellContent = this.documentHandler.executeTemplate(defaultContent);
                                }
                                catch (TemplateException ex) {
                                    throw new DocumentHandlerException(this.locator(), "Failed to evaluate default cell content: " + ex.getMessage(), ex);
                                }
                            } else {
                                cellContent = currentRow.formatValue(columnIdx);
                            }
                        } else {
                            FormatHelper formatHelper = this.documentHandler.getFormatHelper();
                            Format format = this.documentHandler.lookupFormat(formatString);
                            Object cellObject = currentRow.getObject(columnIdx);
                            if (format == null) {
                                switch (column.getType()) {
                                    case 2: 
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        format = formatHelper.createNumberFormat(formatString);
                                        break;
                                    }
                                    case 8: 
                                    case 9: 
                                    case 10: {
                                        format = formatHelper.createDateFormat(formatString);
                                    }
                                }
                                this.documentHandler.registerFormat(formatString, format);
                            }
                            cellContent = format.format(cellObject);
                        }
                    } else {
                        defaultContent = null;
                        if (this.isHeaderRow()) {
                            if (column != null) {
                                defaultContent = column.getLayoutHints().getHeader();
                            }
                        } else {
                            defaultContent = this.rowContainer.getDefaultContent(i);
                        }
                        if (!BeanUtils.isEmpty(defaultContent)) {
                            try {
                                cellContent = this.documentHandler.executeTemplate(defaultContent);
                            }
                            catch (TemplateException ex) {
                                throw new DocumentHandlerException(this.locator(), "Failed to evaluate default cell content: " + ex.getMessage(), ex);
                            }
                        }
                    }
                    if (cellContent == null && this.isHeaderRow()) {
                        cellContent = column.getLayoutHints().getHeader();
                    }
                    Phrase cellPhrase = this.addChunk(this, new Phrase(0.0f), cellContent, font, attrs.getLeading(), attrs.getLineSpacing());
                    if (rotate != 0.0f) {
                        cellPhrase = this.rotatePhrase(cellPhrase, rotate);
                    }
                    cell = new PdfPCell(cellPhrase);
                    attrs.setLeading(0.0f);
                    attrs.setColspan(colspan);
                    attrs.setupCell(cell);
                }
                if (colspan > 1) {
                    i += colspan - 1;
                }
                if (this.isHeaderRow()) {
                    this.rowContainer.addHeaderCell(this, cell);
                    continue;
                }
                this.rowContainer.addCell(this, cell);
            }
        }
        catch (TableException ex) {
            throw new DocumentHandlerException(this.locator(), "Failed to access table cell: " + ex.getMessage(), ex);
        }
    }

    public void registerRowCell(RowCellTag rowCell) throws DocumentHandlerException {
        int index = rowCell.getColumnIndex();
        if (index < 0) {
            index = this.rowContainer.getColumnIndex(rowCell.getColumnName());
        }
        if (index < 0) {
            throw new DocumentHandlerException(this.locator(), "Unable to register row-cell for undefined column '" + rowCell.getColumnName() + "'.");
        }
        if (index >= this.registeredRowCells.length) {
            throw new DocumentHandlerException(this.locator(), "Unable to register row-cell: index " + index + " is out of range.");
        }
        this.registeredRowCells[index] = rowCell;
    }

    public boolean isTrue() {
        Row currentRow = (Row)this.rowContainer.getCurrentValue();
        return currentRow != null && "normal".equals(currentRow.getType());
    }

    protected boolean isHeaderRow() {
        return false;
    }

    public CellAttributes getCellAttributes() {
        return this.cellAttributes;
    }
}

