/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentTagFactory;
import org.ujac.print.tag.CommonAttributes;

public class RegisterTagTag
extends BaseDocumentTag {
    private static final AttributeDefinition TAG_NAME_ATTR = CommonAttributes.NAME.cloneAttrDef("The name of the tag to register.");
    private static final AttributeDefinition TAG_CLASS = new AttributeDefinition("tag-class", 4, true, "The fully qualified tag implementation class name.");
    public static final String TAG_NAME = "register-tag";

    public RegisterTagTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Registers the specified tag class.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(TAG_NAME_ATTR).addDefinition(TAG_CLASS);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        String tagName = this.getStringAttribute(TAG_NAME_ATTR, true, null);
        String tagClassName = this.getStringAttribute(TAG_CLASS, true, null);
        try {
            Class<?> tagClass = Class.forName(tagClassName);
            DocumentTagFactory tagFactory = this.getDocumentHandler().getTagFactory();
            tagFactory.registerTag(tagName, tagClass);
        }
        catch (ClassNotFoundException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to register tag implementation class '" + tagClassName + "', check class path.");
        }
    }
}

