/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.PrintTableTag;

public class RemoveColumnTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "remove-column";
    private static final AttributeDefinition COLUMN_NAME = CommonAttributes.COLUMN_NAME.cloneAttrDef("The name of the column to remove.");
    private PrintTableTag printTableTag = null;

    public RemoveColumnTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Removes a column from the surrounding &lt;print-table&gt; tag.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(COLUMN_NAME);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.printTableTag = (PrintTableTag)this.documentHandler.latestOfType(PrintTableTag.class);
    }

    public void openItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (!this.printTableTag.isFirstLoop()) {
            return;
        }
        String name = this.getStringAttribute(CommonAttributes.COLUMN_NAME, true, null);
        this.printTableTag.removeColumn(name);
    }
}

