/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.Condition;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentMetaData;
import org.ujac.print.ElementContainer;
import org.ujac.print.JavascriptContainer;
import org.ujac.print.NewPageHandler;
import org.ujac.print.tag.AddRowTag;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.AnnotationTag;
import org.ujac.print.tag.AssertTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.BaseLoopTag;
import org.ujac.print.tag.BoxTag;
import org.ujac.print.tag.ChapterTag;
import org.ujac.print.tag.ColumnTextTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DefineTableTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.FooterTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.HeaderTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.JavascriptTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.MetaTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NewPageTag;
import org.ujac.print.tag.OutlineTag;
import org.ujac.print.tag.OverlayTag;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.PrintTableTag;
import org.ujac.print.tag.ResourceBundleTag;
import org.ujac.print.tag.SetFormatTag;
import org.ujac.print.tag.SetPropertyTag;
import org.ujac.print.tag.StickyTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TableTag;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.print.tag.graphics.GraphicsTag;
import org.ujac.util.CollectionUtils;
import org.ujac.util.template.TemplateContext;

public class SegmentTag
extends BaseLoopTag
implements Condition,
ElementContainer,
JavascriptContainer,
NewPageHandler {
    protected static final AttributeDefinition LOOP_VARIABLE = CommonAttributes.LOOP_VARIABLE.cloneAttrDef().setRequired(false);
    protected static final AttributeDefinition SEQUENCE = CommonAttributes.SEQUENCE.cloneAttrDef().setRequired(false);
    public static final String TAG_NAME = "segment";
    private Document originalDocument = null;
    private DocWriter originalDocumentWriter = null;
    private TemplateContext originalTemplateContext = null;
    private Map originalResourceRegistry = null;
    private PdfPageEvent originalPageEventHandler = null;
    private Rectangle originalPageSize = null;
    private ByteArrayOutputStream segmentStream = null;
    private Document segmentDocument = null;
    private DocWriter segmentWriter = null;
    private TemplateContext segmentTemplateContext = null;
    private Rectangle segmentPageSize = null;
    private Map resourceRegistry = null;
    private PdfPageEvent segmentPageEventHandler = null;
    private int pageCounter = 0;
    private float lineSpacing = 1.2f;
    private float marginLeft = 0.0f;
    private float marginRight = 0.0f;
    private float marginTop = 0.0f;
    private float marginBottom = 0.0f;

    public SegmentTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Inserts a sub document into the main document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(LOOP_VARIABLE).addDefinition(SEQUENCE).addDefinition(CommonAttributes.TRIM_BODY).addDefinition(CommonAttributes.PAGE_SIZE).addDefinition(CommonAttributes.PAGE_WIDTH).addDefinition(CommonAttributes.PAGE_HEIGHT).addDefinition(CommonAttributes.PAGE_ROTATE).addDefinition(CommonAttributes.MARGIN_LEFT).addDefinition(CommonAttributes.MARGIN_RIGHT).addDefinition(CommonAttributes.MARGIN_TOP).addDefinition(CommonAttributes.MARGIN_BOTTOM).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.LINE_SPACING);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.PAGE_SIZE).addDefinition(CommonStyleAttributes.PAGE_WIDTH).addDefinition(CommonStyleAttributes.PAGE_HEIGHT).addDefinition(CommonStyleAttributes.PAGE_ROTATE).addDefinition(CommonStyleAttributes.MARGIN_LEFT).addDefinition(CommonStyleAttributes.MARGIN_RIGHT).addDefinition(CommonStyleAttributes.MARGIN_TOP).addDefinition(CommonStyleAttributes.MARGIN_BOTTOM).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.LINE_SPACING);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(HeaderTag.class, 0, 1)).addDefinition(new ChildDefinition(FooterTag.class, 0, 1)).addDefinition(new ChildDefinition(StickyTag.class, 0, 1)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(ChapterTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 999)).addDefinition(new ChildDefinition(ParagraphTag.class, 0, 999)).addDefinition(new ChildDefinition(TableTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableTag.class, 0, 999)).addDefinition(new ChildDefinition(PrintTableTag.class, 0, 999)).addDefinition(new ChildDefinition(SetFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(ResourceBundleTag.class, 0, 999)).addDefinition(new ChildDefinition(AnchorTag.class, 0, 999)).addDefinition(new ChildDefinition(AnnotationTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(MetaTag.class, 0, 1)).addDefinition(new ChildDefinition(ListTag.class, 0, 999)).addDefinition(new ChildDefinition(OverlayTag.class, 0, 999)).addDefinition(new ChildDefinition(BoxTag.class, 0, 999)).addDefinition(new ChildDefinition(SetPropertyTag.class, 0, 999)).addDefinition(new ChildDefinition(DefineTableTag.class, 0, 999)).addDefinition(new ChildDefinition(AddRowTag.class, 0, 999)).addDefinition(new ChildDefinition(AssertTag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(NewPageTag.class, 0, 999)).addDefinition(new ChildDefinition(OutlineTag.class, 0, 999)).addDefinition(new ChildDefinition(ColumnTextTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseAcroFieldTag.class, 0, 999)).addDefinition(new ChildDefinition(GraphicsTag.class, 0, 999)).addDefinition(new ChildDefinition(JavascriptTag.class, 0, 999));
    }

    public void openItem() throws DocumentHandlerException {
        if (!this.isAttributeDefined(LOOP_VARIABLE)) {
            this.setLoopVariable("segmentIdx");
        }
        if (!this.isAttributeDefined(SEQUENCE)) {
            this.setSequenceHolder(CollectionUtils.createArrayList(new Integer(1)));
        }
        super.openItem();
        ElementContainer elementContainer = this.getElementContainer();
        this.lineSpacing = this.isAttributeDefined(CommonAttributes.LINE_SPACING, CommonStyleAttributes.LINE_SPACING) ? this.getDimensionAttribute(CommonAttributes.LINE_SPACING, true, CommonStyleAttributes.LINE_SPACING) : (elementContainer != null ? elementContainer.getLineSpacing() : 1.2f);
        this.originalDocument = this.documentHandler.getDocument();
        this.originalDocumentWriter = this.documentHandler.getDocumentWriter();
        this.originalTemplateContext = this.documentHandler.getTemplateContext();
        this.originalResourceRegistry = this.documentHandler.getResourceRegistry();
        this.originalPageEventHandler = this.documentHandler.getPageEventHandler();
        this.originalPageSize = this.originalDocument.getPageSize();
        String sizeAttr = this.getStringAttribute(CommonAttributes.PAGE_SIZE, true, CommonStyleAttributes.PAGE_SIZE);
        if (sizeAttr != null) {
            try {
                Field sizeField = PageSize.class.getField(sizeAttr);
                this.segmentPageSize = (Rectangle)sizeField.get(null);
            }
            catch (Exception e) {
                throw new DocumentHandlerException(this.locator(), "Unable to set page size: " + e.getMessage(), e);
            }
        } else if (this.isAttributeDefined(CommonAttributes.PAGE_WIDTH) && this.isAttributeDefined(CommonAttributes.PAGE_HEIGHT)) {
            float width = this.getFloatAttribute(CommonAttributes.PAGE_WIDTH, true, CommonStyleAttributes.PAGE_WIDTH);
            float height = this.getFloatAttribute(CommonAttributes.PAGE_HEIGHT, true, CommonStyleAttributes.PAGE_HEIGHT);
            this.segmentPageSize = new Rectangle(width, height);
        }
        if (this.segmentPageSize != null) {
            String rotateAttr = this.getStringAttribute(CommonAttributes.ROTATE, true, CommonStyleAttributes.ROTATE);
            boolean rotate = false;
            if (rotateAttr != null) {
                rotate = new Boolean(rotateAttr);
            }
            Color bgColor = this.getColorAttribute(CommonAttributes.BACKGROUND_COLOR, true, CommonStyleAttributes.BACKGROUND_COLOR);
            if (rotate) {
                this.segmentPageSize = this.segmentPageSize.rotate();
            }
            if (bgColor != null) {
                this.segmentPageSize.setBackgroundColor(bgColor);
            }
        } else {
            this.segmentPageSize = this.originalPageSize;
        }
        this.marginLeft = this.isAttributeDefined(CommonAttributes.MARGIN_LEFT) ? this.getFloatAttribute(CommonAttributes.MARGIN_LEFT, true, CommonStyleAttributes.MARGIN_LEFT) : this.originalDocument.leftMargin();
        this.marginRight = this.isAttributeDefined(CommonAttributes.MARGIN_RIGHT) ? this.getFloatAttribute(CommonAttributes.MARGIN_RIGHT, true, CommonStyleAttributes.MARGIN_RIGHT) : this.originalDocument.rightMargin();
        this.marginTop = this.isAttributeDefined(CommonAttributes.MARGIN_TOP) ? this.getFloatAttribute(CommonAttributes.MARGIN_TOP, true, CommonStyleAttributes.MARGIN_TOP) : this.originalDocument.topMargin();
        this.marginBottom = this.isAttributeDefined(CommonAttributes.MARGIN_BOTTOM) ? this.getFloatAttribute(CommonAttributes.MARGIN_BOTTOM, true, CommonStyleAttributes.MARGIN_BOTTOM) : this.originalDocument.bottomMargin();
        try {
            if (this.segmentPageSize.getRotation() != 0) {
                this.originalDocument.setPageSize(new Rectangle(this.segmentPageSize.getHeight(), this.segmentPageSize.getWidth()));
            } else {
                this.originalDocument.setPageSize(this.segmentPageSize);
            }
            this.originalDocument.newPage();
        }
        catch (Exception ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to start new page: " + ex.getMessage(), ex);
        }
        this.segmentPageEventHandler = this.documentHandler.createPageEventHandler();
        ((PdfWriter)this.originalDocumentWriter).setPageEvent(null);
        this.pageCounter = 0;
    }

    public void closeItem() throws DocumentHandlerException {
        super.closeItem();
        try {
            this.originalDocument.setPageSize(this.originalPageSize);
            this.originalDocument.newPage();
        }
        catch (Exception ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to start new page: " + ex.getMessage(), ex);
        }
        this.documentHandler.setTemplateContext(this.originalTemplateContext);
        this.documentHandler.setDocumentAndWriter(this.originalDocument, this.originalDocumentWriter, this.originalResourceRegistry, this.originalPageEventHandler);
    }

    protected boolean preRepeatChildItems() throws DocumentHandlerException {
        this.segmentDocument = new Document(this.segmentPageSize, this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
        this.segmentTemplateContext = new TemplateContext(this.documentHandler.getTemplateContext());
        this.documentHandler.setTemplateContext(this.segmentTemplateContext);
        this.segmentStream = new ByteArrayOutputStream();
        this.resourceRegistry = new HashMap();
        try {
            this.segmentWriter = PdfWriter.getInstance((Document)this.segmentDocument, (OutputStream)this.segmentStream);
            DocumentMetaData metaData = this.documentHandler.getMetaData();
            if (metaData != null) {
                ((PdfWriter)this.segmentWriter).setPDFXConformance(metaData.getPdfxConformance());
                ((PdfWriter)this.segmentWriter).setPdfVersion(metaData.getPdfVersion());
            }
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to create segment writer: " + ex.getMessage(), ex);
        }
        this.documentHandler.setDocumentAndWriter(this.segmentDocument, this.segmentWriter, this.resourceRegistry, this.segmentPageEventHandler);
        return true;
    }

    protected void postRepeatChildItems() throws DocumentHandlerException {
        if (this.segmentDocument == null) {
            return;
        }
        this.segmentDocument.close();
        try {
            byte[] content = this.segmentStream.toByteArray();
            PdfReader reader = new PdfReader(content);
            int numPages = reader.getNumberOfPages();
            PdfWriter writer = (PdfWriter)this.originalDocumentWriter;
            for (int page = 1; page <= numPages; ++page) {
                PdfImportedPage importedPage = writer.getImportedPage(reader, page);
                PdfContentByte directContent = writer.getDirectContent();
                directContent.addTemplate((PdfTemplate)importedPage, 0.0f, 0.0f);
                if (page != numPages || this.hasNext()) {
                    this.originalDocument.setPageSize(importedPage.getBoundingBox());
                    this.originalDocument.newPage();
                }
                ++this.pageCounter;
            }
            this.documentHandler.setTemplateContext(this.originalTemplateContext);
            this.documentHandler.setDocumentAndWriter(this.originalDocument, this.originalDocumentWriter, this.originalResourceRegistry, this.originalPageEventHandler);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to read segment document: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new DocumentHandlerException(this.locator(), "Document processing failed: " + ex.getMessage(), ex);
        }
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        try {
            Document document = this.getDocument(true);
            if (item instanceof ParagraphTag) {
                ParagraphTag tag = (ParagraphTag)item;
                float leading = tag.getLeading();
                float lineSpacing = tag.getLineSpacing();
                this.extendLeading((Phrase)((Paragraph)element), item.getFont().getFont(), leading, lineSpacing);
            }
            document.add(element);
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add element <" + item.getName() + "> to the " + this.getName() + ": " + ex.getMessage(), ex);
        }
    }

    public boolean isTopLevel() {
        return true;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public float getLeading() {
        return 0.0f;
    }

    public Document getDocument() {
        return this.getDocument(true);
    }

    protected void setDocument(Document document) {
        this.segmentDocument = document;
    }

    public Document getDocument(boolean openDocumentRequired) {
        if (openDocumentRequired && !this.segmentDocument.isOpen()) {
            this.segmentDocument.open();
        }
        return this.segmentDocument;
    }

    public Document handleNewPage(Rectangle size, Rectangle margins) throws DocumentHandlerException {
        try {
            if (size != null) {
                this.segmentDocument.setPageSize(size);
            }
            if (margins != null) {
                this.segmentDocument.setMargins(margins.getBorderWidthLeft(), margins.getBorderWidthRight(), margins.getBorderWidthTop(), margins.getBorderWidthBottom());
            }
            this.segmentDocument.newPage();
        }
        catch (Exception ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to start a new page: " + ex.getMessage(), ex);
        }
        return this.segmentDocument;
    }

    public void addJavaScript(String code) {
        PdfWriter pdfWriter = (PdfWriter)this.documentHandler.getDocumentWriter();
        pdfWriter.addJavaScript(code);
    }
}

