/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.awt.Color;
import java.awt.Font;
import org.ujac.chart.ChartItemPosition;
import org.ujac.chart.TextChartItem;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ParameterHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.util.template.TemplateException;

public class TextChartItemTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "text-chart-item";
    private ParameterHolder parameterHolder = null;
    private String name = null;
    private String fontName = null;
    private int hAlign = 0;
    private int vAlign = 0;
    private int textAlign = 0;
    private boolean rotate = false;

    public TextChartItemTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a text item parameter to its surrounding chart tag.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(CommonAttributes.NAME).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.TEXT_ALIGNMENT).addDefinition(CommonAttributes.ROTATE_FLAG);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.TEXT_ALIGNMENT).addDefinition(CommonStyleAttributes.ROTATE_FLAG);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.parameterHolder = (ParameterHolder)((Object)this.documentHandler.latestOfType(ParameterHolder.class));
        if (this.parameterHolder == null) {
            throw new DocumentHandlerException(this.locator(), "Item '" + this.getName() + "' is not supported here.");
        }
        this.name = this.getStringAttribute(CommonAttributes.NAME, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.fontName = this.getStringAttribute(CommonAttributes.FONT, true, CommonStyleAttributes.FONT_NAME);
        this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        this.vAlign = this.getVerticalAlignmentAttribute(CommonAttributes.VERTICAL_ALIGNMENT, true, CommonStyleAttributes.VERTICAL_ALIGNMENT);
        this.textAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.TEXT_ALIGNMENT, true, CommonStyleAttributes.TEXT_ALIGNMENT);
        if (!this.isAttributeDefined(CommonAttributes.TEXT_ALIGNMENT, CommonStyleAttributes.TEXT_ALIGNMENT)) {
            this.textAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        }
        this.rotate = this.getBooleanAttribute(CommonAttributes.ROTATE, true, CommonStyleAttributes.ROTATE);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        String expr = this.getContent();
        TextChartItem value = null;
        try {
            String text = this.documentHandler.executeTemplate(expr);
            Font textFont = null;
            Color textColor = null;
            DocumentFont docFont = null;
            docFont = this.fontName != null ? this.documentHandler.getFont(this.fontName) : this.getFont();
            if (docFont != null) {
                textFont = this.documentHandler.getAwtFont(docFont);
                textColor = docFont.getColor();
            }
            short hAlign = 0;
            switch (this.hAlign) {
                case 0: {
                    hAlign = 1;
                    break;
                }
                case 1: {
                    hAlign = 2;
                    break;
                }
                case 2: {
                    hAlign = 3;
                    break;
                }
                default: {
                    hAlign = 1;
                }
            }
            short vAlign = 0;
            switch (this.vAlign) {
                case 4: {
                    vAlign = 4;
                    break;
                }
                case 5: {
                    vAlign = 5;
                    break;
                }
                case 6: {
                    vAlign = 6;
                    break;
                }
                default: {
                    vAlign = 4;
                }
            }
            value = new TextChartItem(new ChartItemPosition(hAlign, vAlign), this.textAlign, text, textFont, textColor).setRotate(this.rotate);
        }
        catch (TemplateException ex) {
            throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
        }
        this.parameterHolder.setParameter(this.name, value);
    }
}

