/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.util.template.TemplateContext;

public class TogglePropertyTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "toggle-property";
    private static final AttributeDefinition PROPERTY_NAME = CommonAttributes.PROPERTY_NAME.cloneAttrDef("The name of the property to toggle.");
    private String name = null;
    private String type = null;

    public TogglePropertyTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Toggles the value for a specific property. Each time this tag is executed it changes its value from a to b or vice versa.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(PROPERTY_NAME).addDefinition(CommonAttributes.PROPERTY_TYPE).addDefinition(CommonAttributes.PROPERTY_A).addDefinition(CommonAttributes.PROPERTY_B);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.name = this.getStringAttribute(CommonAttributes.PROPERTY_NAME, false, null);
        this.type = this.getStringAttribute(CommonAttributes.PROPERTY_TYPE, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        Object a = this.typeCastValue(this.getStringAttribute(CommonAttributes.PROPERTY_A, false, null), this.type);
        Object b = this.typeCastValue(this.getStringAttribute(CommonAttributes.PROPERTY_B, false, null), this.type);
        TemplateContext ctx = this.documentHandler.getTemplateContext();
        Object curVal = ctx.getProperty(this.name);
        if (curVal == null || curVal.equals(b)) {
            ctx.setProperty(this.name, a);
        } else {
            ctx.setProperty(this.name, b);
        }
    }
}

