/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PushbuttonField;
import java.awt.Color;
import java.io.IOException;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.util.template.TemplateException;

public class ResetButtonAcroFieldTag
extends BaseAcroFieldTag {
    public static final String TAG_NAME = "reset-button";
    protected String fieldValue = null;
    protected String url = null;

    public ResetButtonAcroFieldTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a reset button to the documents AcroForm.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(FIELD_VALUE).addDefinition(CommonAttributes.FONT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.fieldValue = this.getStringAttribute(FIELD_VALUE, true, null);
    }

    public PdfFormField addFormField(PdfAcroForm form) throws DocumentHandlerException {
        String caption = null;
        try {
            caption = this.documentHandler.executeTemplate(this.getContent());
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
        }
        try {
            DocumentFont font = this.getFont();
            BaseFont bf = font.getFont().getBaseFont();
            PdfWriter pdfWriter = this.getPdfWriter();
            PushbuttonField pbf = new PushbuttonField(pdfWriter, this.getFieldDimensions(), this.fieldName);
            pbf.setFont(bf);
            int rotation = this.documentHandler.getDocument().getPageSize().getRotation();
            pbf.setRotation(rotation);
            pbf.setFontSize(font.getSize());
            pbf.setText(caption);
            pbf.setBorderStyle(this.getBorderStyle());
            pbf.setBorderWidth(this.getBorderWidth());
            pbf.setBorderColor(this.getBorderColor());
            Color backgroundColor = this.getBackgroundColor();
            if (backgroundColor == null) {
                backgroundColor = Color.lightGray;
            }
            pbf.setBackgroundColor(backgroundColor);
            pbf.setTextColor(this.getTextColor());
            pbf.setLayout(1);
            PdfFormField ff = pbf.getField();
            ff.setAction(PdfAction.createResetForm(null, (int)1));
            return ff;
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
    }

    protected int getBorderStyle() {
        return 2;
    }
}

