/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import com.lowagie.text.pdf.PdfContentByte;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class DrawCurveTag
extends BaseGraphicsTag {
    public static final String TAG_NAME = "draw-curve";
    private static final AttributeDefinition CURVE_X1 = X1.cloneAttrDef("The horizontal position of the start point.");
    private static final AttributeDefinition CURVE_Y1 = Y1.cloneAttrDef("The vertical position of the start point.");
    private static final AttributeDefinition CURVE_X2 = X2.cloneAttrDef("The horizontal position of the first control point.");
    private static final AttributeDefinition CURVE_Y2 = Y2.cloneAttrDef("TThe vertical position of the first control point.");
    private static final AttributeDefinition CURVE_X3 = X3.cloneAttrDef("The horizontal position of the second control point.");
    private static final AttributeDefinition CURVE_Y3 = Y3.cloneAttrDef("TThe vertical position of the second control point.");
    private static final AttributeDefinition CURVE_X4 = X4.cloneAttrDef("The horizontal position of the end point.");
    private static final AttributeDefinition CURVE_Y4 = Y4.cloneAttrDef("The vertical position of the end point.");

    public DrawCurveTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Draws a rectangle.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(FILL).addDefinition(CURVE_X1).addDefinition(CURVE_Y1).addDefinition(CURVE_X2).addDefinition(CURVE_Y2).addDefinition(CURVE_X3).addDefinition(CURVE_Y3).addDefinition(CURVE_X4).addDefinition(CURVE_Y4);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        boolean fill = this.getBooleanAttribute(FILL, false, true, null);
        float x1 = this.getDimensionAttribute(X1, true, null);
        float y1 = this.getDimensionAttribute(Y1, true, null);
        float x2 = this.getDimensionAttribute(Y2, -1.0f, true, (AttributeDefinition)null);
        float y2 = this.getDimensionAttribute(Y2, -1.0f, true, (AttributeDefinition)null);
        float x3 = this.getDimensionAttribute(X3, -1.0f, true, (AttributeDefinition)null);
        float y3 = this.getDimensionAttribute(Y3, -1.0f, true, (AttributeDefinition)null);
        float x4 = this.getDimensionAttribute(X4, true, null);
        float y4 = this.getDimensionAttribute(Y4, true, null);
        PdfContentByte cb = this.graphicsTag.getContentByte();
        cb.moveTo(x1, y1);
        if (x2 < 0.0f || y2 < 0.0f) {
            if (x3 < 0.0f || y3 < 0.0f) {
                throw new TagAttributeException(this.locator(), "Eigther the first or second control point have to be defined for curves.");
            }
            cb.curveTo(x3, y3, x4, y4);
        } else if (x3 < 0.0f || y3 < 0.0f) {
            cb.curveFromTo(x2, y2, x4, y4);
        } else {
            cb.curveTo(x2, y2, x3, y3, x4, y4);
        }
        if (fill) {
            cb.fillStroke();
        } else {
            cb.stroke();
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

