/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import com.lowagie.text.pdf.PdfContentByte;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class DrawEllipseTag
extends BaseGraphicsTag {
    public static final String TAG_NAME = "draw-ellipse";
    private static final AttributeDefinition ELLIPSE_FILL = FILL.cloneAttrDef("Tells whether or not to fill the ellipse, default is false.");
    private static final AttributeDefinition ELLIPSE_X1 = X1.cloneAttrDef("The horizontal position of the start point of the ellipse.");
    private static final AttributeDefinition ELLIPSE_Y1 = Y1.cloneAttrDef("The vertical position of the start point of the ellipse.");
    private static final AttributeDefinition ELLIPSE_X2 = X2.cloneAttrDef("The horizontal position of the end point of the ellipse.");
    private static final AttributeDefinition ELLIPSE_Y2 = Y2.cloneAttrDef("The vertical position of the end point of the ellipse.");

    public DrawEllipseTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Draws a ellipse.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(ELLIPSE_FILL).addDefinition(ELLIPSE_X1).addDefinition(ELLIPSE_Y1).addDefinition(ELLIPSE_X2).addDefinition(ELLIPSE_Y2);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        boolean fill = this.getBooleanAttribute(FILL, false, true, null);
        float x1 = this.getDimensionAttribute(X1, true, null);
        float y1 = this.getDimensionAttribute(Y1, true, null);
        float x2 = this.getDimensionAttribute(X2, true, null);
        float y2 = this.getDimensionAttribute(Y2, true, null);
        PdfContentByte cb = this.graphicsTag.getContentByte();
        cb.ellipse(x1, y1, x2, y2);
        if (fill) {
            cb.fillStroke();
        } else {
            cb.stroke();
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

