/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import com.lowagie.text.pdf.PdfContentByte;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;
import org.ujac.print.tag.graphics.PointHolder;
import org.ujac.print.tag.graphics.PointTag;

public class DrawPolyLineTag
extends BaseGraphicsTag
implements PointHolder {
    public static final String TAG_NAME = "draw-poly-line";
    private int numPoints = 0;

    public DrawPolyLineTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Draws a poly line.";
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(PointTag.class, 0, 999));
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.numPoints = 0;
        if (!this.isValid()) {
            return;
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        PdfContentByte cb = this.graphicsTag.getContentByte();
        cb.stroke();
    }

    public void addPoint(float x, float y) throws TagAttributeException {
        PdfContentByte cb = this.graphicsTag.getContentByte();
        if (this.numPoints == 0) {
            cb.moveTo(x, y);
        } else {
            cb.lineTo(x, y);
        }
        ++this.numPoints;
    }
}

