/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class GraphicsTag
extends BaseDocumentTag {
    protected static final AttributeDefinition STROKE_COLOR = new AttributeDefinition("stroke-color", 5, false, "The stroke color for graphical operations.");
    protected static final AttributeDefinition FILL_COLOR = new AttributeDefinition("fill-color", 5, false, "The fill color for graphical operations.");
    protected static final AttributeDefinition LINE_WIDTH = new AttributeDefinition("line-width", 14, false, "The line width for graphical operations.");
    protected static final AttributeDefinition DRAW_FOREGROUND = new AttributeDefinition("draw-foreground", 3, false, "Tells whether to draw the image in the foreground or in the background. The default value for this attribute is true.");
    public static final String TAG_NAME = "graphics";
    private Color strokeColor = null;
    private Color fillColor = null;
    private float lineWidth = 1.0f;
    private boolean drawForeground = true;
    private PdfContentByte cb = null;

    public GraphicsTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a graphics area.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(STROKE_COLOR).addDefinition(FILL_COLOR).addDefinition(LINE_WIDTH).addDefinition(DRAW_FOREGROUND);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseGraphicsTag.class, 0, 999));
    }

    public boolean isTextBodyAllowed() {
        return false;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.strokeColor = this.getColorAttribute(STROKE_COLOR, Color.black, true, null);
        this.fillColor = this.getColorAttribute(FILL_COLOR, Color.black, true, null);
        this.lineWidth = this.getDimensionAttribute(LINE_WIDTH, 1.0f, true, (AttributeDefinition)null);
        this.drawForeground = this.getBooleanAttribute(DRAW_FOREGROUND, true, true, null);
        this.cb = this.drawForeground ? ((PdfWriter)this.documentHandler.getDocumentWriter()).getDirectContent() : ((PdfWriter)this.documentHandler.getDocumentWriter()).getDirectContentUnder();
        this.cb.saveState();
        this.cb.setColorStroke(this.strokeColor);
        this.cb.setColorFill(this.fillColor);
        this.cb.setLineWidth(this.lineWidth);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.cb.restoreState();
    }

    public PdfContentByte getContentByte() {
        return this.cb;
    }

    public void setStrokeColor(Color color) {
        if (color == null) {
            this.cb.resetCMYKColorStroke();
        } else {
            this.cb.setColorStroke(color);
        }
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.cb.resetCMYKColorFill();
        } else {
            this.cb.setColorFill(color);
        }
    }

    public void setLineWidth(float width) {
        this.cb.setLineWidth(width);
    }

    public void setLineCap(int lineCap) {
        this.cb.setLineCap(lineCap);
    }

    public void setLineJoin(int lineJoin) {
        this.cb.setLineJoin(lineJoin);
    }

    public void setLineDash(float phase, float unitsOn, float unitsOff) {
        if (unitsOff > 0.0f) {
            this.cb.setLineDash(unitsOn, unitsOn, phase);
        } else if (unitsOn > 0.0f) {
            this.cb.setLineDash(unitsOn, phase);
        } else {
            this.cb.setLineDash(phase);
        }
    }
}

