/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class SetLineJoinTag
extends BaseGraphicsTag {
    protected static final AttributeDefinition LINE_JOIN = new AttributeDefinition("line-join", new String[]{"miter", "round", "bevel"}, true, "The line join to set.");
    public static final String TAG_NAME = "set-line-join";

    public SetLineJoinTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the current line dash for the surrounding graphics area.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(LINE_JOIN);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        String strLineJoin = this.getStringAttribute(LINE_JOIN, "miter", true, null).toLowerCase();
        int lineJoin = 0;
        if ("miter".equals(strLineJoin)) {
            lineJoin = 0;
        } else if ("round".equals(strLineJoin)) {
            lineJoin = 1;
        } else if ("bevel".equals(strLineJoin)) {
            lineJoin = 2;
        }
        this.graphicsTag.setLineJoin(lineJoin);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

