/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ujac.util.BeanException;
import org.ujac.util.DefaultTypeConverter;
import org.ujac.util.StringUtils;
import org.ujac.util.TypeConverter;
import org.ujac.util.TypeConverterException;

public class BeanUtils {
    public static final Class[] GETTER_ARG_TYPES = new Class[0];
    public static final Object[] GETTER_ARGS = new Object[0];

    public static final Object getProperty(Object bean, String propertyName) throws BeanException {
        return BeanUtils.getProperty(bean, propertyName, false);
    }

    public static final Class getPropertyType(Class clazz, String propertyName, boolean lenient) throws BeanException {
        block6: {
            try {
                Method getterMethod = null;
                try {
                    String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                    getterMethod = clazz.getMethod(getterName, GETTER_ARG_TYPES);
                }
                catch (NoSuchMethodException ex) {
                    String getterName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                    getterMethod = clazz.getMethod(getterName, GETTER_ARG_TYPES);
                }
                return getterMethod.getReturnType();
            }
            catch (NoSuchMethodError ex) {
                if (!lenient) {
                    throw new BeanException("Property '" + propertyName + "' is undefined for given bean from class " + clazz.getName() + ".");
                }
            }
            catch (NoSuchMethodException ex) {
                if (lenient) break block6;
                throw new BeanException("Property '" + propertyName + "' is undefined for given bean from class " + clazz.getName() + ".");
            }
        }
        return null;
    }

    public static final Object getProperty(Object bean, String propertyName, boolean lenient) throws BeanException {
        try {
            Method getterMethod = null;
            try {
                String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                Class<?> paramClass = bean.getClass();
                getterMethod = paramClass.getMethod(getterName, GETTER_ARG_TYPES);
            }
            catch (NoSuchMethodException ex) {
                String getterName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                Class<?> paramClass = bean.getClass();
                getterMethod = paramClass.getMethod(getterName, GETTER_ARG_TYPES);
            }
            return getterMethod.invoke(bean, GETTER_ARGS);
        }
        catch (NoSuchMethodError ex) {
            if (!lenient) {
                throw new BeanException("Property '" + propertyName + "' is undefined for given bean from class " + bean.getClass().getName() + ".", ex);
            }
        }
        catch (NoSuchMethodException ex) {
            if (!lenient) {
                throw new BeanException("Property '" + propertyName + "' is undefined for given bean from class " + bean.getClass().getName() + ".");
            }
        }
        catch (InvocationTargetException ex) {
            throw new BeanException("Property '" + propertyName + "' could not be evaluated for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanException("Property '" + propertyName + "' could not be accessed for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        return null;
    }

    public static final Object invokeGetter(Object bean, Method getterMethod) throws BeanException {
        if (bean == null) {
            return null;
        }
        try {
            return getterMethod.invoke(bean, GETTER_ARGS);
        }
        catch (InvocationTargetException ex) {
            throw new BeanException("Failed to call getter method '" + getterMethod.getName() + "' for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanException("Failed to call getter method '" + getterMethod.getName() + "' for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanException("Failed to call getter method '" + getterMethod.getName() + "' for given bean from class " + bean.getClass().getName() + ".", ex);
        }
    }

    public static final void setProperty(Object bean, String propertyName, Object value) throws BeanException {
        Class<?> valueClass = null;
        try {
            Method setterMethod = null;
            String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            Class<?> paramClass = bean.getClass();
            if (value != null) {
                valueClass = value.getClass();
                Class[] setterArgTypes = new Class[]{valueClass};
                setterMethod = paramClass.getMethod(setterName, setterArgTypes);
            } else {
                Method[] methods = paramClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (!m.getName().equals(setterName) || m.getParameterTypes().length != 1) continue;
                    setterMethod = m;
                    break;
                }
            }
            Object[] setterArgs = new Object[]{value};
            setterMethod.invoke(bean, setterArgs);
        }
        catch (NoSuchMethodError ex) {
            throw new BeanException("No setter method found for property '" + propertyName + "' and type " + valueClass + " at given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new BeanException("No setter method found for property '" + propertyName + "' and type " + valueClass + " at given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanException("Property '" + propertyName + "' could not be set for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanException("Property '" + propertyName + "' could not be accessed for given bean from class " + bean.getClass().getName() + ".", ex);
        }
    }

    public static final void invokeSetter(Object bean, Method setterMethod, Object value) throws BeanException {
        DefaultTypeConverter tc = new DefaultTypeConverter();
        BeanUtils.invokeSetter(bean, setterMethod, value, tc);
    }

    public static final void invokeSetter(Object bean, Method setterMethod, Object value, TypeConverter typeConverter) throws BeanException {
        if (bean == null) {
            return;
        }
        try {
            Class<?> paramType = null;
            Class<?>[] paramTypes = setterMethod.getParameterTypes();
            if (paramTypes.length == 1) {
                paramType = paramTypes[0];
            }
            Object arg = typeConverter.convertObject(paramType, value);
            Object[] setterArgs = new Object[]{arg};
            setterMethod.invoke(bean, setterArgs);
        }
        catch (InvocationTargetException ex) {
            throw new BeanException("Failed to call setter method '" + setterMethod.getName() + "' for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanException("Failed to call setter method '" + setterMethod.getName() + "' for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanException("Failed to call setter method '" + setterMethod.getName() + "' for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        catch (TypeConverterException ex) {
            throw new BeanException("Type conversion failed for method '" + setterMethod.getName() + "' at given bean from class " + bean.getClass().getName() + ".", ex);
        }
    }

    public static final boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static final boolean equals(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public static final boolean equals(Object a, Object b, boolean caseSensitive) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof String) {
            return StringUtils.equals(a.toString(), b.toString(), caseSensitive);
        }
        return a.equals(b);
    }

    public static final int compare(Comparable a, Comparable b) {
        if (a == null || b == null) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            return 1;
        }
        return a.compareTo(b);
    }

    public static final boolean between(Comparable obj, Comparable from, Comparable to) {
        int compareObjFrom = BeanUtils.compare(obj, from);
        int compareObjTo = BeanUtils.compare(obj, to);
        return compareObjFrom >= 0 && compareObjTo <= 0;
    }

    public static final String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }
}

