/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import org.ujac.util.DateUtils;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.type.BaseType;
import org.ujac.util.text.FormatHelper;

public abstract class BaseDateType
extends BaseType {
    protected abstract Date evalDate(Operand var1, ExpressionContext var2) throws ExpressionException;

    protected abstract String execToString(ExpressionTuple var1, FormatHelper var2);

    protected abstract int compareDates(Date var1, Date var2);

    public BaseDateType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new EqualOperation();
        this.addOperation("==", op);
        this.addOperation("eq", op);
        op = new GreaterOperation();
        this.addOperation(">", op);
        this.addOperation("gt", op);
        op = new GreaterEqualOperation();
        this.addOperation(">=", op);
        this.addOperation("ge", op);
        op = new LessOperation();
        this.addOperation("<", op);
        this.addOperation("lt", op);
        op = new LessEqualOperation();
        this.addOperation("<=", op);
        this.addOperation("le", op);
        op = new ReferenceOperation();
        this.addOperation(".", op);
        this.addOperation("->", op);
        op = new BeginOfYearOperation();
        this.addOperation("beginOfYear", op);
        op = new EndOfYearOperation();
        this.addOperation("endOfYear", op);
        this.addOperation("min", new MinOperation());
        this.addOperation("max", new MaxOperation());
        this.addOperation("prevUltimo", new PreviousUltimoOperation());
        this.addOperation("nextUltimo", new NextUltimoOperation());
        this.addOperation("incrDay", new IncrementDayOperation());
        this.addOperation("incrMonth", new IncrementMonthOperation());
        this.addOperation("incrYear", new IncrementYearOperation());
        this.addOperation("decrDay", new DecrementDayOperation());
        this.addOperation("decrMonth", new DecrementMonthOperation());
        this.addOperation("decrYear", new DecrementYearOperation());
        this.addOperation("getDay", new GetDayOperation());
        this.addOperation("getMonth", new GetMonthOperation());
        this.addOperation("getYear", new GetYearOperation());
        this.addOperation("setDay", new SetDayOperation());
        this.addOperation("setMonth", new SetMonthOperation());
        this.addOperation("setYear", new SetYearOperation());
        this.addOperation("format", new FormatOperation());
    }

    public class FormatOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            String formatName;
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = operand.getValue();
            Format format = null;
            FormatHelper formatHelper = ctx.getFormatHelper();
            if (operandValue instanceof String && (format = formatHelper.lookupFormat(formatName = (String)operandValue)) == null) {
                format = formatHelper.createDateFormat(formatName);
                formatHelper.registerFormat(formatName, format);
            }
            return format.format(expr.getObject().getValue());
        }

        public String getDescription() {
            return "Formats the object using the format, specified by the operand.";
        }
    }

    public class ReferenceOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = BaseDateType.this.interpreter.evalStringOperand(operand, ctx);
            Calendar cal = DateUtils.createCalendar((Date)expr.getObject().getValue());
            if ("year".equals(operandValue)) {
                return new Integer(DateUtils.getYear(cal));
            }
            if ("month".equals(operandValue)) {
                return new Integer(DateUtils.getMonth(cal));
            }
            if ("day".equals(operandValue)) {
                return new Integer(DateUtils.getDay(cal));
            }
            if ("hour".equals(operandValue)) {
                return new Integer(DateUtils.getHour(cal));
            }
            if ("minute".equals(operandValue)) {
                return new Integer(DateUtils.getMinute(cal));
            }
            if ("second".equals(operandValue)) {
                return new Integer(DateUtils.getSecond(cal));
            }
            if ("millisecond".equals(operandValue)) {
                return new Integer(DateUtils.getMillisecond(cal));
            }
            throw new OperandException("Unknown property '" + operandValue + "' for date values at expression '" + expr.getCode() + "'.");
        }

        public String getDescription() {
            return "Accesses the fields of the date by the given operand name.\nValid names are:\n\t year: Get the year field of the date\n \t month: Get the month field of the date\n \t day: Get the day field of the date\n \t hour: Get the hour of day field of the date\n \t minute: Get the minute field of the date\n \t second: Get the second field of the date\n \t millisecond: Get the millisecond field of the date";
        }
    }

    public class GetDayOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Integer(DateUtils.getDay((Date)expr.getObject().getValue()));
        }

        public String getDescription() {
            return "Gets the day field from the date, specified by the object.";
        }
    }

    public class GetMonthOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Integer(DateUtils.getMonth((Date)expr.getObject().getValue()));
        }

        public String getDescription() {
            return "Gets the month field from the date, specified by the object.";
        }
    }

    public class GetYearOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Integer(DateUtils.getYear((Date)expr.getObject().getValue()));
        }

        public String getDescription() {
            return "Gets the year field from the date, specified by the object.";
        }
    }

    public class NextUltimoOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return DateUtils.nextUltimo((Date)expr.getObject().getValue());
        }

        public String getDescription() {
            return "Gets the next ultimo of the date, specified by the object. The ultimo date is the last day of a month. In case the day is the 15th of April, the resulting object will be the 30th of April.";
        }
    }

    public class PreviousUltimoOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return DateUtils.previousUltimo((Date)expr.getObject().getValue());
        }

        public String getDescription() {
            return "Gets the previous ultimo of the date, specified by the object. The ultimo date is the last day of a month. In case the day is the 15th of April, the resulting object will be the 31th of March.";
        }
    }

    public class EndOfYearOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return DateUtils.endOfYear((Date)expr.getObject().getValue());
        }

        public String getDescription() {
            return "Gets the end of year (December, 31st) for the date, specified by the object.";
        }
    }

    public class BeginOfYearOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return DateUtils.beginOfYear((Date)expr.getObject().getValue());
        }

        public String getDescription() {
            return "Gets the begin of year (January, 1st) for the date, specified by the object.";
        }
    }

    public class MaxOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Date operandValue = BaseDateType.this.evalDate(operand, ctx);
            return DateUtils.min((Date)expr.getObject().getValue(), operandValue);
        }

        public String getDescription() {
            return "Gets the maximum of the object and the operand value.";
        }
    }

    public class MinOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Date operandValue = BaseDateType.this.evalDate(operand, ctx);
            return DateUtils.min((Date)expr.getObject().getValue(), operandValue);
        }

        public String getDescription() {
            return "Gets the minimum of the object and the operand value.";
        }
    }

    public class SetDayOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.setDay((Date)expr.getObject().getValue(), operandValue);
        }

        public String getDescription() {
            return "Sets the value of the object's day to the value, specified by the operand.";
        }
    }

    public class DecrementDayOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.incrDay((Date)expr.getObject().getValue(), -operandValue);
        }

        public String getDescription() {
            return "Decrements the value of the object's day by the amount, specified by the operand.";
        }
    }

    public class IncrementDayOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.incrDay((Date)expr.getObject().getValue(), operandValue);
        }

        public String getDescription() {
            return "Increments the value of the object's day by the amount, specified by the operand.";
        }
    }

    public class SetMonthOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.setMonth((Date)expr.getObject().getValue(), operandValue);
        }

        public String getDescription() {
            return "Sets the value of the object's month to the value, specified by the operand.";
        }
    }

    public class DecrementMonthOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.incrMonth((Date)expr.getObject().getValue(), -operandValue);
        }

        public String getDescription() {
            return "Decrements the value of the object's month by the amount, specified by the operand.";
        }
    }

    public class IncrementMonthOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.incrMonth((Date)expr.getObject().getValue(), operandValue);
        }

        public String getDescription() {
            return "Increments the value of the object's month by the amount, specified by the operand.";
        }
    }

    public class SetYearOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.setYear((Date)expr.getObject().getValue(), operandValue);
        }

        public String getDescription() {
            return "Sets the value of the object's year to the value, specified by the operand.";
        }
    }

    public class DecrementYearOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.incrYear((Date)expr.getObject().getValue(), -operandValue);
        }

        public String getDescription() {
            return "Decrements the value of the object's year by the amount, specified by the operand.";
        }
    }

    public class IncrementYearOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = BaseDateType.this.interpreter.evalIntOperand(operand, ctx, false);
            return DateUtils.incrYear((Date)expr.getObject().getValue(), operandValue);
        }

        public String getDescription() {
            return "Increments the value of the object's year by the amount, specified by the operand.";
        }
    }

    public class LessEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Date operandValue = BaseDateType.this.evalDate(operand, ctx);
            return new Boolean(BaseDateType.this.compareDates((Date)expr.getObject().getValue(), operandValue) <= 0);
        }

        public String getDescription() {
            return "Checks if the object is smaller than or equal to the operand.";
        }
    }

    public class GreaterEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Date operandValue = BaseDateType.this.evalDate(operand, ctx);
            return new Boolean(BaseDateType.this.compareDates((Date)expr.getObject().getValue(), operandValue) >= 0);
        }

        public String getDescription() {
            return "Checks if the object is greater than or equal to the operand.";
        }
    }

    public class LessOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Date operandValue = BaseDateType.this.evalDate(operand, ctx);
            return new Boolean(BaseDateType.this.compareDates((Date)expr.getObject().getValue(), operandValue) < 0);
        }

        public String getDescription() {
            return "Checks if the object is smaller than the operand.";
        }
    }

    public class GreaterOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Date operandValue = BaseDateType.this.evalDate(operand, ctx);
            return new Boolean(BaseDateType.this.compareDates((Date)expr.getObject().getValue(), operandValue) > 0);
        }

        public String getDescription() {
            return "Checks if the object is greater than the operand.";
        }
    }

    public class NotEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Date operandValue = BaseDateType.this.evalDate(operand, ctx);
            return new Boolean(BaseDateType.this.compareDates((Date)expr.getObject().getValue(), operandValue) != 0);
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class EqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Date operandValue = BaseDateType.this.evalDate(operand, ctx);
            return new Boolean(BaseDateType.this.compareDates((Date)expr.getObject().getValue(), operandValue) == 0);
        }

        public String getDescription() {
            return "Compares the object with the operand for equality.";
        }
    }
}

