/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.text.Format;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.type.BaseType;
import org.ujac.util.text.FormatHelper;

public abstract class BaseNumberType
extends BaseType {
    public BaseNumberType(ExpressionInterpreter interpreter) {
        super(interpreter);
        this.addOperation("format", new FormatOperation());
    }

    public abstract Number getNegative(Number var1);

    public class FormatOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            String formatName;
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = operand.getValue();
            Format format = null;
            FormatHelper formatHelper = ctx.getFormatHelper();
            if (operandValue instanceof String && (format = formatHelper.lookupFormat(formatName = (String)operandValue)) == null) {
                format = formatHelper.createNumberFormat(formatName);
                formatHelper.registerFormat(formatName, format);
            }
            return format.format(expr.getObject().getValue());
        }

        public String getDescription() {
            return "Formats the object using the format, specified by the operand.";
        }
    }
}

