/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ConditionResultHolder;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.type.BaseType;

public class BooleanType
extends BaseType {
    public BooleanType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new EqualOperation();
        this.addOperation("==", op);
        this.addOperation("eq", op);
        op = new NotEqualOperation();
        this.addOperation("!=", op);
        this.addOperation("ne", op);
        op = new NotOperation();
        this.addOperation("not", op);
        op = new AndOperation();
        this.addOperation("&&", op);
        this.addOperation("and", op);
        op = new OrOperation();
        this.addOperation("||", op);
        this.addOperation("or", op);
        op = new ConditionOperation();
        this.addOperation("?", op);
    }

    public Class getType() {
        return Boolean.class;
    }

    public String getAlias() {
        return "boolean";
    }

    public class ConditionOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            boolean value = (Boolean)expr.getObject().getValue();
            if (!value) {
                return new ConditionResultHolder(false, null);
            }
            return new ConditionResultHolder(true, BooleanType.this.interpreter.evalOperand(operand, ctx));
        }

        public String getDescription() {
            return "Combines the object and the operand with the 'and' operation.";
        }
    }

    public class AndOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            boolean value = (Boolean)expr.getObject().getValue();
            if (!value) {
                return Boolean.FALSE;
            }
            return new Boolean(BooleanType.this.interpreter.evalBooleanOperand(operand, ctx));
        }

        public String getDescription() {
            return "Combines the object and the operand with the 'and' operation.";
        }
    }

    public class OrOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            boolean value = (Boolean)expr.getObject().getValue();
            if (value) {
                return Boolean.TRUE;
            }
            return new Boolean(BooleanType.this.interpreter.evalBooleanOperand(operand, ctx));
        }

        public String getDescription() {
            return "Combines the object and the operand with the 'or' operation.";
        }
    }

    public class NotOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            boolean value = (Boolean)expr.getObject().getValue();
            return new Boolean(!value);
        }

        public String getDescription() {
            return "Toggles the object's value: true becomes false and vice versa.";
        }
    }

    public class NotEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            boolean operandValue = BooleanType.this.interpreter.evalBooleanOperand(operand, ctx);
            return new Boolean((Boolean)expr.getObject().getValue() != operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class EqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            boolean operandValue = BooleanType.this.interpreter.evalBooleanOperand(operand, ctx);
            return new Boolean((Boolean)expr.getObject().getValue() == operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for equality.";
        }
    }
}

