/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ujac.util.BeanException;
import org.ujac.util.BeanUtils;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.type.BaseType;

public class CollectionType
extends BaseType {
    public CollectionType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new IsEmptyOperation();
        this.addOperation("isEmpty", op);
        op = new NotEmptyOperation();
        this.addOperation("notEmpty", op);
        op = new SizeOperation();
        this.addOperation("size", op);
        op = new ContainsOperation();
        this.addOperation("contains", op);
        op = new NotContainsOperation();
        this.addOperation("notContains", op);
        op = new GetOperation();
        this.addOperation(".", op);
        this.addOperation("[]", op);
        this.addOperation("get", op);
        op = new SortOperation();
        this.addOperation("sort", op);
    }

    public Class getType() {
        return Collection.class;
    }

    public class SortOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            String sortByValue;
            String sortByField = null;
            Operand operand = expr.getOperand();
            if (operand != null && (sortByValue = CollectionType.this.interpreter.evalOperand(operand, ctx).toString()) != null) {
                sortByField = sortByValue.toString();
            }
            Collection list = (Collection)expr.getObject().getValue();
            ArrayList sortList = new ArrayList();
            sortList.addAll(list);
            Collections.sort(sortList, new BeanComparator(sortByField));
            return sortList;
        }

        public String getDescription() {
            return "Sorts the collection. If an operand is given, it sorts the collection according to the bean field name the operand specifies.";
        }
    }

    private static class BeanComparator
    implements Comparator {
        private String fieldName = null;

        public BeanComparator(String fieldName) {
            this.fieldName = fieldName;
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = null;
            Comparable c2 = null;
            if (this.fieldName != null) {
                try {
                    c1 = (Comparable)BeanUtils.getProperty(o1, this.fieldName);
                    c2 = (Comparable)BeanUtils.getProperty(o2, this.fieldName);
                }
                catch (BeanException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            } else {
                c1 = (Comparable)o1;
                c2 = (Comparable)o2;
            }
            return c1.compareTo(c2);
        }
    }

    public class GetOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = CollectionType.this.interpreter.evalIntOperand(operand, ctx, false);
            try {
                List list = (List)expr.getObject().getValue();
                return list.get(operandValue);
            }
            catch (ClassCastException ex) {
                throw new ExpressionException("The operation " + expr.getOperation() + " is only supported for List-type collections.");
            }
        }

        public String getDescription() {
            return "Gets an element from the collection. This operation is only implemented for List instances";
        }
    }

    public class NotContainsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = CollectionType.this.interpreter.evalOperand(operand, ctx);
            Collection col = (Collection)expr.getObject().getValue();
            return new Boolean(!col.contains(operandValue));
        }

        public String getDescription() {
            return "Checks if the collection not contains the operand value.";
        }
    }

    public class ContainsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = CollectionType.this.interpreter.evalOperand(operand, ctx);
            Collection col = (Collection)expr.getObject().getValue();
            return new Boolean(col.contains(operandValue));
        }

        public String getDescription() {
            return "Checks if the collection contains the operand value.";
        }
    }

    public class SizeOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Collection col = (Collection)expr.getObject().getValue();
            return new Integer(col.size());
        }

        public String getDescription() {
            return "Determines the size of the collection.";
        }
    }

    public class NotEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Collection col = (Collection)expr.getObject().getValue();
            return new Boolean(!col.isEmpty());
        }

        public String getDescription() {
            return "Checks if the collection is not empty.";
        }
    }

    public class IsEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Collection col = (Collection)expr.getObject().getValue();
            return new Boolean(col.isEmpty());
        }

        public String getDescription() {
            return "Tells whether the collection is empty or not.";
        }
    }
}

