/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import org.ujac.util.BeanException;
import org.ujac.util.BeanUtils;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.type.BaseType;

public class DefaultType
extends BaseType {
    public DefaultType(ExpressionInterpreter interpreter) {
        super(interpreter);
        ReferenceOperation ref = new ReferenceOperation();
        this.addOperation(".", ref);
        this.addOperation("->", ref);
        this.addOperation("[]", ref);
        this.addOperation("getField", ref);
        this.addOperation("propertyDefined", new PropertyDefinedOperation());
    }

    public Class getType() {
        return Object.class;
    }

    public class PropertyDefinedOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = DefaultType.this.interpreter.evalStringOperand(operand, ctx);
            Object objectValue = expr.getObject().getValue();
            Class<?> objectClass = objectValue.getClass();
            try {
                BeanUtils.getPropertyType(objectClass, operandValue, false);
                return Boolean.TRUE;
            }
            catch (BeanException ex) {
                return Boolean.FALSE;
            }
        }

        public String getDescription() {
            return "Checks it the object contains a property that matches the name, specified by the operand.";
        }
    }

    public class ReferenceOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = DefaultType.this.interpreter.evalStringOperand(operand, ctx);
            Operand object = expr.getObject();
            Object objectValue = object.getValue();
            if (objectValue == null) {
                throw new OperandException("Unable to resolve reference " + expr.getObject() + " for null value at expression " + expr.toString() + "!");
            }
            try {
                return BeanUtils.getProperty(objectValue, operandValue);
            }
            catch (BeanException ex) {
                throw new OperandException("Failed to resolve property '" + operandValue + " at expression '" + expr.getCode() + "': " + ex.getMessage(), ex);
            }
        }

        public String getDescription() {
            return "Accesses the object's property specified by the operand.";
        }
    }
}

