/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.text.NumberFormat;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.TypeCastException;
import org.ujac.util.exi.type.BaseNumberType;
import org.ujac.util.text.FormatHelper;

public class DoubleType
extends BaseNumberType {
    private Class clazz = null;
    private String alias = null;

    protected String execToString(ExpressionTuple expr, FormatHelper formatHelper) {
        Number value = (Number)expr.getObject().getValue();
        NumberFormat format = formatHelper.getDoubleFormat();
        if (format != null) {
            return format.format(value);
        }
        return value.toString();
    }

    public DoubleType(ExpressionInterpreter interpreter, Class clazz, String alias) {
        super(interpreter);
        this.clazz = clazz;
        this.alias = alias;
        BaseExpressionOperation op = new EqualOperation();
        this.addOperation("==", op);
        this.addOperation("eq", op);
        op = new NotEqualOperation();
        this.addOperation("!=", op);
        this.addOperation("ne", op);
        op = new GreaterOperation();
        this.addOperation(">", op);
        this.addOperation("gt", op);
        op = new GreaterEqualOperation();
        this.addOperation(">=", op);
        this.addOperation("ge", op);
        op = new LessOperation();
        this.addOperation("<", op);
        this.addOperation("lt", op);
        op = new LessEqualOperation();
        this.addOperation("<=", op);
        this.addOperation("le", op);
        op = new AddOperation();
        this.addOperation("+", op);
        this.addOperation("add", op);
        op = new SubOperation();
        this.addOperation("-", op);
        this.addOperation("sub", op);
        op = new MulOperation();
        this.addOperation("*", op);
        this.addOperation("mul", op);
        op = new DivOperation();
        this.addOperation("/", op);
        this.addOperation("div", op);
        this.addOperation("min", new MinOperation());
        this.addOperation("max", new MaxOperation());
        this.addOperation("abs", new AbsOperation());
    }

    public Class getType() {
        return this.clazz;
    }

    public String getAlias() {
        return this.alias;
    }

    public Number getNegative(Number number) {
        return new Double(number.doubleValue() * -1.0);
    }

    public Object typeCast(Object value) throws TypeCastException {
        if (value instanceof String) {
            String strValue = (String)value;
            try {
                double doubleVal = Double.parseDouble(strValue);
                return new Double(doubleVal);
            }
            catch (NumberFormatException ex) {
                throw new TypeCastException("Unable to parse double value from '" + strValue + "'.");
            }
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        throw new TypeCastException("Unable to transform value '" + value + "' into a double.");
    }

    public class AbsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Number object = (Number)expr.getObject().getValue();
            return new Double(Math.abs(object.doubleValue()));
        }

        public String getDescription() {
            return "Determines the object's absolute value.";
        }
    }

    public class MaxOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            Number object = (Number)expr.getObject().getValue();
            if (object.doubleValue() > operandValue) {
                return object;
            }
            return new Double(operandValue);
        }

        public String getDescription() {
            return "Gets the maximum of the object and the operand value.";
        }
    }

    public class MinOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            Number object = (Number)expr.getObject().getValue();
            if (object.doubleValue() < operandValue) {
                return object;
            }
            return new Double(operandValue);
        }

        public String getDescription() {
            return "Gets the minimum of the object and the operand value.";
        }
    }

    public class DivOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Double(((Number)expr.getObject().getValue()).doubleValue() / operandValue);
        }

        public String getDescription() {
            return "Calculates the quotient of the object and the operand value.";
        }
    }

    public class MulOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Double(((Number)expr.getObject().getValue()).doubleValue() * operandValue);
        }

        public String getDescription() {
            return "Calculates the product of the object and the operand value.";
        }
    }

    public class SubOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Double(((Number)expr.getObject().getValue()).doubleValue() - operandValue);
        }

        public String getDescription() {
            return "Calculates the difference of the object and the operand value.";
        }
    }

    public class AddOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Double(((Number)expr.getObject().getValue()).doubleValue() + operandValue);
        }

        public String getDescription() {
            return "Calculates the sum of the object and the operand value.";
        }
    }

    public class LessEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Boolean(((Number)expr.getObject().getValue()).doubleValue() <= operandValue);
        }

        public String getDescription() {
            return "Checks if the object is smaller than or equal to the operand.";
        }
    }

    public class GreaterEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Boolean(((Number)expr.getObject().getValue()).doubleValue() >= operandValue);
        }

        public String getDescription() {
            return "Checks if the object is greater than or equal to the operand.";
        }
    }

    public class LessOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Boolean(((Number)expr.getObject().getValue()).doubleValue() < operandValue);
        }

        public String getDescription() {
            return "Checks if the object is smaller than the operand.";
        }
    }

    public class GreaterOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Boolean(((Number)expr.getObject().getValue()).doubleValue() > operandValue);
        }

        public String getDescription() {
            return "Checks if the object is greater than the operand.";
        }
    }

    public class NotEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Boolean(((Number)expr.getObject().getValue()).doubleValue() != operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class EqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = DoubleType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Boolean(((Number)expr.getObject().getValue()).doubleValue() == operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for equality.";
        }
    }
}

