/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.NullType;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.type.BaseType;

public class NullValueType
extends BaseType {
    public NullValueType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new ReferenceOperation();
        this.addOperation(".", op);
        this.addOperation("->", op);
        this.addOperation("[]", op);
        this.addOperation("get", op);
        this.addOperation("getField", op);
        this.addOperation("propertyDefined", new PropertyDefinedOperation());
        op = new IsEmptyOperation();
        this.addOperation("isEmpty", op);
        this.addOperation("noRows", op);
        op = new NotEmptyOperation();
        this.addOperation("notEmpty", op);
        this.addOperation("hasRows", op);
        op = new SizeOperation();
        this.addOperation("size", op);
        this.addOperation("rowCount", op);
        this.addOperation("format", new FormatOperation());
        op = new EqualOperation();
        this.addOperation("==", op);
        this.addOperation("eq", op);
        op = new NotEqualOperation();
        this.addOperation("!=", op);
        this.addOperation("ne", op);
        op = new GreaterOperation();
        this.addOperation(">", op);
        this.addOperation("gt", op);
        op = new GreaterEqualOperation();
        this.addOperation(">=", op);
        this.addOperation("ge", op);
        op = new LessOperation();
        this.addOperation("<", op);
        this.addOperation("lt", op);
        op = new LessEqualOperation();
        this.addOperation("<=", op);
        this.addOperation("le", op);
        op = new AddOperation();
        this.addOperation("+", op);
        this.addOperation("add", op);
        op = new SubOperation();
        this.addOperation("-", op);
        this.addOperation("sub", op);
        op = new MulOperation();
        this.addOperation("*", op);
        this.addOperation("mul", op);
        op = new DivOperation();
        this.addOperation("/", op);
        this.addOperation("div", op);
        this.addOperation("min", new MinOperation());
        this.addOperation("max", new MaxOperation());
        this.addOperation("abs", new AbsOperation());
    }

    public Class getType() {
        return NullType.class;
    }

    public String getTypeName() {
        return "null Reference";
    }

    public String getDescription() {
        return "A special handler for null values to avoid some error messages, resulting from not declared operations at the default handler.";
    }

    public class AbsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Double(0.0);
        }

        public String getDescription() {
            return "Determines the object's absolute value.";
        }
    }

    public class MaxOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = NullValueType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Double(operandValue);
        }

        public String getDescription() {
            return "Gets the maximum of the object and the operand value.";
        }
    }

    public class MinOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = NullValueType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            if (operandValue < 0.0) {
                return new Double(0.0);
            }
            return new Double(0.0);
        }

        public String getDescription() {
            return "Gets the minimum of the object and the operand value.";
        }
    }

    public class DivOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Double(0.0);
        }

        public String getDescription() {
            return "Calculates the quotient of the object and the operand value.";
        }
    }

    public class MulOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Double(0.0);
        }

        public String getDescription() {
            return "Calculates the product of the object and the operand value.";
        }
    }

    public class SubOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = NullValueType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Double(-operandValue);
        }

        public String getDescription() {
            return "Calculates the difference of the object and the operand value.";
        }
    }

    public class AddOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            double operandValue = NullValueType.this.interpreter.evalDoubleOperand(operand, ctx, false);
            return new Double(operandValue);
        }

        public String getDescription() {
            return "Calculates the sum of the object and the operand value.";
        }
    }

    public class LessEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return Boolean.TRUE;
        }

        public String getDescription() {
            return "Checks if the object is smaller than or equal to the operand.";
        }
    }

    public class GreaterEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = NullValueType.this.interpreter.evalOperand(operand, ctx);
            return new Boolean(operandValue == null);
        }

        public String getDescription() {
            return "Checks if the object is greater than or equal to the operand.";
        }
    }

    public class LessOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = NullValueType.this.interpreter.evalOperand(operand, ctx);
            return new Boolean(operandValue != null);
        }

        public String getDescription() {
            return "Checks if the object is smaller than the operand.";
        }
    }

    public class GreaterOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return Boolean.FALSE;
        }

        public String getDescription() {
            return "Checks if the object is greater than the operand.";
        }
    }

    public class NotEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = NullValueType.this.interpreter.evalOperand(operand, ctx);
            return new Boolean(expr.getObject().getValue() != operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class EqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = NullValueType.this.interpreter.evalOperand(operand, ctx);
            if (operandValue instanceof Number) {
                return new Boolean(((Number)operandValue).doubleValue() == 0.0);
            }
            return new Boolean(expr.getObject().getValue() == operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for equality.";
        }
    }

    public class FormatOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return "";
        }

        public String getDescription() {
            return "Formats the object using the format, specified by the operand (always '').";
        }
    }

    public class SizeOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            return new Integer(0);
        }

        public String getDescription() {
            return "Determines the size of the object (always 0).";
        }
    }

    public class NotEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return Boolean.FALSE;
        }

        public String getDescription() {
            return "Checks if the object is not empty.";
        }
    }

    public class IsEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return Boolean.TRUE;
        }

        public String getDescription() {
            return "Tells whether the object is empty or not.";
        }
    }

    public class PropertyDefinedOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return Boolean.FALSE;
        }

        public String getDescription() {
            return "Checks it the object contains a property that matches the name, specified by the operand.";
        }
    }

    public class ReferenceOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            throw new OperandException("Unable to resolve reference " + expr.getObject() + " for null value at expression " + expr.toString() + "!");
        }

        public String getDescription() {
            return "Accesses the object's property specified by the operand.";
        }
    }
}

