/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.util.StringTokenizer;
import org.ujac.util.BeanUtils;
import org.ujac.util.StringUtils;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.type.BaseType;

public class StringType
extends BaseType {
    public StringType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new EqualOperation();
        this.addOperation("==", op);
        this.addOperation("eq", op);
        op = new NotEqualOperation();
        this.addOperation("!=", op);
        this.addOperation("ne", op);
        op = new LikeOperation();
        this.addOperation("like", op);
        op = new NotLikeOperation();
        this.addOperation("notLike", op);
        op = new ConcatOperation();
        this.addOperation("+", op);
        this.addOperation("concat", op);
        this.addOperation("trim", new TrimOperation());
        this.addOperation("length", new LengthOperation());
        this.addOperation("lowerCase", new LowerCaseOperation());
        this.addOperation("upperCase", new UpperCaseOperation());
        this.addOperation("capitalize", new CapitalizeOperation());
        this.addOperation("isEmpty", new IsEmptyOperation());
        this.addOperation("notEmpty", new NotEmptyOperation());
        this.addOperation("substring", new SubstringOperation());
    }

    public Class getType() {
        return String.class;
    }

    public String getAlias() {
        return "String";
    }

    public class SubstringOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new OperandNotSupportedException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String obj = (String)expr.getObject().getValue();
            int tIdx = 0;
            int start = 0;
            int end = 0;
            StringTokenizer tkn = new StringTokenizer(BeanUtils.toString(operand.getValue()), ":", true);
            while (tkn.hasMoreTokens()) {
                String t = tkn.nextToken();
                if (t.charAt(0) == ':') {
                    if (++tIdx != 1) continue;
                    ++tIdx;
                    continue;
                }
                if (tIdx == 0) {
                    try {
                        start = Integer.parseInt(t);
                    }
                    catch (NumberFormatException ex) {
                        throw new OperandException("Illegal operand '" + operand.getValue() + "' for operation " + expr.getOperation() + " on object " + expr.getObject() + ", expected numeric values.");
                    }
                }
                if (tIdx == 2) {
                    try {
                        end = Integer.parseInt(t);
                    }
                    catch (NumberFormatException ex) {
                        throw new OperandException("Illegal operand '" + operand.getValue() + "' for operation " + expr.getOperation() + " on object " + expr.getObject() + ", expected numeric values.");
                    }
                }
                ++tIdx;
            }
            if (end > 0) {
                return obj.substring(start, end);
            }
            return obj.substring(start);
        }

        public String getDescription() {
            return "Returns a substring of the object the operation is applied to. The operand can be given in the forms '&lt;start&gt;', '&lt;start&gt;:&lt;length&gt;', ':length'.";
        }
    }

    public class NotEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Boolean(((String)expr.getObject().getValue()).length() > 0);
        }

        public String getDescription() {
            return "Checks if the String has no zero length.";
        }
    }

    public class IsEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Boolean(((String)expr.getObject().getValue()).length() == 0);
        }

        public String getDescription() {
            return "Checks if the String has zero length.";
        }
    }

    public class CapitalizeOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return StringUtils.capitalize((String)expr.getObject().getValue());
        }

        public String getDescription() {
            return "Raises the first character of the given String.";
        }
    }

    public class UpperCaseOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return ((String)expr.getObject().getValue()).toUpperCase();
        }

        public String getDescription() {
            return "Gets the object as upper case string.";
        }
    }

    public class LowerCaseOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return ((String)expr.getObject().getValue()).toLowerCase();
        }

        public String getDescription() {
            return "Gets the object as lower case string.";
        }
    }

    public class LengthOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return new Integer(((String)expr.getObject().getValue()).length());
        }

        public String getDescription() {
            return "Gets the length of the object.";
        }
    }

    public class TrimOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return ((String)expr.getObject().getValue()).trim();
        }

        public String getDescription() {
            return "Trims the leading and trailing white spaces from the object.";
        }
    }

    public class ConcatOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = StringType.this.interpreter.evalStringOperand(operand, ctx);
            return (String)expr.getObject().getValue() + operandValue;
        }

        public String getDescription() {
            return "Concatenates the object and the operand.";
        }
    }

    public class NotLikeOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = StringType.this.interpreter.evalStringOperand(operand, ctx);
            int operandLength = operandValue.length();
            if (operandLength < 1) {
                return Boolean.TRUE;
            }
            if (operandValue.charAt(0) == '%') {
                if (operandValue.charAt(operandLength - 1) == '%') {
                    String compareText = operandValue.substring(1, operandLength - 1);
                    return new Boolean(((String)expr.getObject().getValue()).indexOf(compareText) < 0);
                }
                return new Boolean(!((String)expr.getObject().getValue()).endsWith(operandValue.substring(1)));
            }
            if (operandValue.charAt(operandLength - 1) == '%') {
                String compareText = operandValue.substring(0, operandLength - 1);
                return new Boolean(!((String)expr.getObject().getValue()).startsWith(compareText));
            }
            return new Boolean(((String)expr.getObject().getValue()).indexOf(operandValue) < 0);
        }

        public String getDescription() {
            return "Compares the object with the operand for similarity. This operation behaves similar to the 'like' operation, known from SQL. In case the operand starts and ends with '%', text within the wildcard marks has to occur somewhere within the object. In case the operand only starts with '%', the object has to end with the operand text. In case the operand only ends with '%', the object has to start with the operand text. If none of the cases above matches, this operation behaves like the 'equal' operation.";
        }
    }

    public class LikeOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = StringType.this.interpreter.evalStringOperand(operand, ctx);
            int operandLength = operandValue.length();
            if (operandLength < 1) {
                return Boolean.FALSE;
            }
            return new Boolean(StringUtils.like((String)expr.getObject().getValue(), operandValue));
        }
    }

    public class NotEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = StringType.this.interpreter.evalStringOperand(operand, ctx);
            return new Boolean(!((String)expr.getObject().getValue()).equals(operandValue));
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class EqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = StringType.this.interpreter.evalStringOperand(operand, ctx);
            return new Boolean(((String)expr.getObject().getValue()).equals(operandValue));
        }

        public String getDescription() {
            return "Compares the object with the operand for equality.";
        }
    }
}

