/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.type.BaseDateType;
import org.ujac.util.text.FormatHelper;

public class TimeType
extends BaseDateType {
    protected String execToString(ExpressionTuple expr, FormatHelper formatHelper) {
        Time value = (Time)expr.getObject().getValue();
        DateFormat format = formatHelper.getTimeFormat();
        if (format != null) {
            return format.format((Object)value);
        }
        return value.toString();
    }

    protected Date evalDate(Operand operand, ExpressionContext ctx) throws ExpressionException {
        return this.interpreter.evalTimeOperand(operand, ctx, false);
    }

    protected int compareDates(Date object, Date operand) {
        Calendar objectCal = Calendar.getInstance();
        objectCal.setTime(object);
        Calendar operandCal = Calendar.getInstance();
        operandCal.setTime(operand);
        int objectHour = objectCal.get(11);
        int operandHour = operandCal.get(11);
        int objectMinute = objectCal.get(12);
        int operandMinute = operandCal.get(12);
        int objectSecond = objectCal.get(13);
        int operandSecond = operandCal.get(13);
        if (objectHour > operandHour) {
            return 1;
        }
        if (objectHour < operandHour) {
            return -1;
        }
        if (objectMinute > operandMinute) {
            return 1;
        }
        if (objectMinute < operandMinute) {
            return -1;
        }
        if (objectSecond > operandSecond) {
            return 1;
        }
        if (objectSecond < operandSecond) {
            return -1;
        }
        return 0;
    }

    public TimeType(ExpressionInterpreter interpreter) {
        super(interpreter);
    }

    public Class getType() {
        return Time.class;
    }

    public String getAlias() {
        return "Time";
    }
}

