/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.type.BaseDateType;
import org.ujac.util.text.FormatHelper;

public class TimestampType
extends BaseDateType {
    protected String execToString(ExpressionTuple expr, FormatHelper formatHelper) {
        Timestamp value = (Timestamp)expr.getObject().getValue();
        DateFormat format = formatHelper.getTimestampFormat();
        if (format != null) {
            return format.format((Object)value);
        }
        return value.toString();
    }

    protected Date evalDate(Operand operand, ExpressionContext ctx) throws ExpressionException {
        return this.interpreter.evalTimestampOperand(operand, ctx, false);
    }

    protected int compareDates(Date object, Date operand) {
        Calendar objectCal = Calendar.getInstance();
        objectCal.setTime(object);
        Calendar operandCal = Calendar.getInstance();
        operandCal.setTime(operand);
        int objectYear = objectCal.get(1);
        int operandYear = operandCal.get(1);
        int objectMonth = objectCal.get(2);
        int operandMonth = operandCal.get(2);
        int objectDay = objectCal.get(5);
        int operandDay = operandCal.get(5);
        int objectHour = objectCal.get(11);
        int operandHour = operandCal.get(11);
        int objectMinute = objectCal.get(12);
        int operandMinute = operandCal.get(12);
        int objectSecond = objectCal.get(13);
        int operandSecond = operandCal.get(13);
        if (objectYear > operandYear) {
            return 1;
        }
        if (objectYear < operandYear) {
            return -1;
        }
        if (objectMonth > operandMonth) {
            return 1;
        }
        if (objectMonth < operandMonth) {
            return -1;
        }
        if (objectDay > operandDay) {
            return 1;
        }
        if (objectDay < operandDay) {
            return -1;
        }
        if (objectHour > operandHour) {
            return 1;
        }
        if (objectHour < operandHour) {
            return -1;
        }
        if (objectMinute > operandMinute) {
            return 1;
        }
        if (objectMinute < operandMinute) {
            return -1;
        }
        if (objectSecond > operandSecond) {
            return 1;
        }
        if (objectSecond < operandSecond) {
            return -1;
        }
        return 0;
    }

    public TimestampType(ExpressionInterpreter interpreter) {
        super(interpreter);
    }

    public Class getType() {
        return Timestamp.class;
    }

    public String getAlias() {
        return "Timestamp";
    }
}

