/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.io;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ujac.util.io.ResourceLoader;

public class ClassResourceLoader
implements ResourceLoader {
    private static final Log log = LogFactory.getLog((String)"ClassResourceLoader");

    public byte[] loadResource(String location) throws IOException {
        Enumeration<URL> resources;
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassResourceLoader.class.getClassLoader();
        }
        if ((resources = loader.getResources(location)).hasMoreElements()) {
            url = resources.nextElement();
            if (resources.hasMoreElements()) {
                log.warn((Object)"*** WARNING ***");
                log.warn((Object)("There are multiple " + location + " files in classpath at the following locations:"));
                log.warn((Object)url.getPath());
                while (resources.hasMoreElements()) {
                    log.warn((Object)resources.nextElement().getPath());
                }
            }
        } else {
            throw new IOException("Could not find the resource: " + location + " in the classpath");
        }
        log.debug((Object)("Loading " + location + " from: " + url.getPath()));
        return ClassResourceLoader.loadFile(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadFile(URL url) {
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        try {
            fis = new FileInputStream(url.getPath());
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int size = fis.read(bytes);
            while (size > -1) {
                baos.write(bytes, 0, size);
                bytes = new byte[1024];
                size = fis.read(bytes);
            }
            baos.flush();
        }
        catch (Exception e) {
            log.error((Object)"Failed to load resource.", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                baos.close();
                fis.close();
            }
            catch (IOException ioe) {
                log.warn((Object)("Error occured when closing the input stream " + ioe.getMessage()));
            }
        }
        return baos.toByteArray();
    }

    public boolean resourceExists(String location) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassResourceLoader.class.getClassLoader();
            }
            Enumeration<URL> resources = loader.getResources(location);
            return resources.hasMoreElements();
        }
        catch (IOException ex) {
            log.error((Object)"Failed to check resource.", (Throwable)ex);
            return false;
        }
    }
}

