/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ujac.util.io.ResourceLoader;

public class HttpResourceLoader
implements ResourceLoader {
    private String urlRoot = null;

    public HttpResourceLoader() {
    }

    public HttpResourceLoader(String urlRoot) {
        this.urlRoot = urlRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadResource(String location) throws IOException {
        if (location == null || location.length() == 0) {
            throw new IOException("The given resource location must not be null and non empty.");
        }
        URL url = this.buildURL(location);
        URLConnection cxn = url.openConnection();
        InputStream is = null;
        try {
            byte[] byteBuffer = new byte[2048];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            is = cxn.getInputStream();
            int bytesRead = 0;
            while ((bytesRead = is.read(byteBuffer, 0, 2048)) >= 0) {
                bos.write(byteBuffer, 0, bytesRead);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceExists(String location) {
        boolean bl;
        block8: {
            if (location == null || location.length() == 0) {
                return false;
            }
            URL url = this.buildURL(location);
            URLConnection cxn = url.openConnection();
            InputStream is = null;
            try {
                byte[] byteBuffer = new byte[2048];
                is = cxn.getInputStream();
                while (is.read(byteBuffer, 0, 2048) >= 0) {
                }
                bl = true;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    private URL buildURL(String location) throws MalformedURLException {
        URL url = null;
        if (this.urlRoot == null) {
            url = new URL(location);
        } else {
            int firstColonIdx = location.indexOf(58);
            int firstSlashIdx = location.indexOf(47);
            url = firstColonIdx > 0 && (firstSlashIdx < 0 || firstColonIdx < firstSlashIdx) ? new URL(location) : (this.urlRoot.endsWith("/") ? new URL(this.urlRoot + location) : new URL(this.urlRoot + "/" + location));
        }
        return url;
    }
}

