/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ujac.util.CollectionUtils;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TypeMismatchException;

public abstract class BaseRow
implements Row,
Serializable {
    static final long serialVersionUID = 3096795524377585326L;
    protected Table table = null;
    protected List rowData = null;
    private Set hiddenFields = null;
    private Map fieldFormats = null;
    private Map fieldAlignments = null;
    private boolean startNewPage = false;
    private boolean startsBlock = false;
    private boolean endsBlock = false;

    public BaseRow(Table table) {
        this.table = table;
        this.rowData = new ArrayList();
        this.expandRow();
    }

    public BaseRow(Table table, Row srcRow) {
        this.table = table;
        this.rowData = new ArrayList();
        int columnCount = table.getColumnCount();
        List srcData = srcRow.asList();
        int srcSize = CollectionUtils.getSize(srcData);
        if (srcSize != columnCount) {
            throw new RuntimeException("copied table row is not compatible!");
        }
        this.rowData.addAll(srcData);
    }

    public Table getTable() {
        return this.table;
    }

    public List asList() {
        return this.rowData;
    }

    public String formatValue(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column col = this.table.getColumn(columnName);
        return this.formatValue(col.getIndex());
    }

    public String formatValue(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        if (!this.isVisible(columnIdx)) {
            return "";
        }
        String value = this.getString(columnIdx);
        if (value == null) {
            return "-";
        }
        return value;
    }

    public boolean isVisible(String columnName) throws ColumnNotDefinedException {
        if (this.hiddenFields != null && this.hiddenFields.contains(columnName)) {
            return false;
        }
        Column column = this.table.getColumn(columnName);
        LayoutHints lh = column.getLayoutHints();
        return lh != null && lh.isVisible();
    }

    public boolean isVisible(int columnIdx) throws ColumnNotDefinedException {
        Column column = this.table.getColumn(columnIdx);
        return this.isVisible(column.getName());
    }

    public void setVisible(String columnName, boolean visible) throws ColumnNotDefinedException {
        if (this.hiddenFields == null) {
            if (visible) {
                return;
            }
            this.hiddenFields = new HashSet();
        }
        if (visible) {
            this.hiddenFields.remove(columnName);
        } else {
            this.hiddenFields.add(columnName);
        }
    }

    public void setVisible(int columnIdx, boolean visible) throws ColumnNotDefinedException {
        Column column = this.table.getColumn(columnIdx);
        this.setVisible(column.getName(), visible);
    }

    public Format getFormat(String columnName) throws ColumnNotDefinedException {
        if (this.fieldFormats == null) {
            return this.table.getColumn(columnName).getFormat();
        }
        Format format = (Format)this.fieldFormats.get(columnName);
        if (format != null) {
            return format;
        }
        return this.table.getColumn(columnName).getFormat();
    }

    public Format getFormat(int columnIdx) throws ColumnNotDefinedException {
        Column column = this.table.getColumn(columnIdx);
        if (this.fieldFormats == null) {
            return column.getFormat();
        }
        Format format = (Format)this.fieldFormats.get(column.getName());
        if (format != null) {
            return format;
        }
        return column.getFormat();
    }

    public void setFormat(String columnName, Format format) throws ColumnNotDefinedException {
        if (this.fieldFormats == null) {
            this.fieldFormats = new HashMap();
        }
        this.fieldFormats.put(columnName, format);
    }

    public void setFormat(int columnIdx, Format format) throws ColumnNotDefinedException {
        Column column = this.table.getColumn(columnIdx);
        this.setFormat(column.getName(), format);
    }

    public int getAlign(String columnName) throws ColumnNotDefinedException {
        if (this.fieldFormats == null) {
            LayoutHints lh = this.table.getColumn(columnName).getLayoutHints();
            return this.getFieldAlignment(lh);
        }
        Integer alignment = (Integer)this.fieldAlignments.get(columnName);
        if (alignment != null) {
            return alignment;
        }
        LayoutHints lh = this.table.getColumn(columnName).getLayoutHints();
        return this.getFieldAlignment(lh);
    }

    public int getAlign(int columnIdx) throws ColumnNotDefinedException {
        Integer alignment;
        Column column = this.table.getColumn(columnIdx);
        if (this.fieldFormats == null) {
            LayoutHints lh = column.getLayoutHints();
            return this.getFieldAlignment(lh);
        }
        if (this.fieldAlignments != null && (alignment = (Integer)this.fieldAlignments.get(column.getName())) != null) {
            return alignment;
        }
        LayoutHints lh = column.getLayoutHints();
        return this.getFieldAlignment(lh);
    }

    protected int getFieldAlignment(LayoutHints lh) {
        if (lh != null) {
            return lh.getAlign();
        }
        return 0;
    }

    public void setAlign(String columnName, int alignment) throws ColumnNotDefinedException {
        if (this.fieldAlignments == null) {
            this.fieldAlignments = new HashMap();
        }
        this.fieldAlignments.put(columnName, new Integer(alignment));
    }

    public void setAlign(int columnIdx, int alignment) throws ColumnNotDefinedException {
        Column column = this.table.getColumn(columnIdx);
        this.setAlign(column.getName(), alignment);
    }

    public boolean isStartNewPage() {
        return this.startNewPage;
    }

    public void setStartNewPage(boolean startNewPage) {
        this.startNewPage = startNewPage;
    }

    public boolean isStartsBlock() {
        return this.startsBlock;
    }

    public void setStartsBlock(boolean startsBlock) {
        this.startsBlock = startsBlock;
    }

    public boolean isEndsBlock() {
        return this.endsBlock;
    }

    public void setEndsBlock(boolean endsBlock) {
        this.endsBlock = endsBlock;
    }

    protected void expandRow() {
        int elementCount;
        int columnCount = this.table.getColumnCount();
        for (int i = elementCount = this.rowData.size(); i < columnCount; ++i) {
            this.rowData.add(null);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getType()).append(": [");
        try {
            Table tab = this.getTable();
            int numColumns = tab.getColumnCount();
            for (int i = 0; i < numColumns; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.getString(i));
            }
        }
        catch (TableException ex) {
            ex.printStackTrace();
        }
        buf.append("]");
        if (this.startNewPage) {
            buf.append(", startNewPage!");
        }
        if (this.startsBlock) {
            buf.append(", startsBlock!");
        }
        if (this.endsBlock) {
            buf.append(", endsBlock!");
        }
        return buf.toString();
    }

    protected void writeData(ObjectOutputStream s) throws IOException {
        s.writeObject(this.table);
        s.writeObject(this.rowData);
        s.writeObject(this.hiddenFields);
        s.writeObject(this.fieldFormats);
        s.writeObject(this.fieldAlignments);
        s.writeBoolean(this.startNewPage);
        s.writeBoolean(this.startsBlock);
        s.writeBoolean(this.endsBlock);
    }

    protected void readData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.table = (Table)s.readObject();
        this.rowData = (List)s.readObject();
        this.hiddenFields = (Set)s.readObject();
        this.fieldFormats = (Map)s.readObject();
        this.fieldAlignments = (Map)s.readObject();
        this.startNewPage = s.readBoolean();
        this.startsBlock = s.readBoolean();
        this.endsBlock = s.readBoolean();
    }
}

