/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ujac.util.BeanUtils;
import org.ujac.util.TypeConverter;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnAlreadyDefinedException;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.DefaultColumn;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.OperationNotSupportedException;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.text.FormatHelper;

public abstract class BaseTable
implements Table {
    private FormatHelper formatHelper = null;
    private TypeConverter typeConverter = null;
    protected List columns = new ArrayList();
    protected Map columnMap = new HashMap();

    public BaseTable() {
        this(null);
    }

    public BaseTable(FormatHelper formatHelper) {
        this.formatHelper = formatHelper == null ? FormatHelper.createInstance() : formatHelper;
    }

    public FormatHelper getFormatHelper() {
        return this.formatHelper;
    }

    public void setFormatHelper(FormatHelper formatHelper) {
        this.formatHelper = formatHelper;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column addColumn(String name, int type) throws ColumnAlreadyDefinedException, OperationNotSupportedException {
        Column col = (Column)this.columnMap.get(name);
        if (col != null) {
            throw new ColumnAlreadyDefinedException("A column with name '" + name + "' already exists.");
        }
        col = new DefaultColumn(this, name, type);
        this.columnMap.put(name, col);
        this.columns.add(col);
        int idx = this.columns.size() - 1;
        col.setIndex(idx);
        col.setDataIndex(idx);
        return col;
    }

    public Column addColumn(String name, boolean key, int type) throws ColumnAlreadyDefinedException {
        Column col = (Column)this.columnMap.get(name);
        if (col != null) {
            throw new ColumnAlreadyDefinedException("A column with name '" + name + "' already exists.");
        }
        col = new DefaultColumn(this, name, key, type);
        this.columnMap.put(name, col);
        this.columns.add(col);
        int idx = this.columns.size() - 1;
        col.setIndex(idx);
        col.setDataIndex(idx);
        return col;
    }

    public Column getColumn(int index) throws ColumnNotDefinedException {
        try {
            return (Column)this.columns.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ColumnNotDefinedException("Column at index " + index + " does not exist.");
        }
    }

    public Column getColumn(String name) throws ColumnNotDefinedException {
        Column col = (Column)this.columnMap.get(name);
        if (col == null) {
            throw new ColumnNotDefinedException("Column '" + name + "' does not exist.");
        }
        return col;
    }

    public int getColumnIndex(String name) throws ColumnNotDefinedException {
        Column col = this.getColumn(name);
        return col.getIndex();
    }

    public void renameColumn(Column column, String name) throws ColumnAlreadyDefinedException {
        if (BeanUtils.equals(name, column.getName())) {
            return;
        }
        if (this.columnMap.get(name) != null) {
            throw new ColumnAlreadyDefinedException("Renaming of column '" + column.getName() + "' failed: A column with name '" + name + "' already exists.");
        }
        this.columnMap.put(name, column);
        this.columnMap.remove(column.getName());
        ((DefaultColumn)column).setName(name);
    }

    public void orderColumns(String[] columnNames) throws ColumnNotDefinedException, ColumnAlreadyDefinedException {
        int i;
        int numColumns = this.columns.size();
        Map columnMap = (Map)((HashMap)this.columnMap).clone();
        HashSet<String> newColumnNames = new HashSet<String>();
        ArrayList<Column> newColumns = new ArrayList<Column>(numColumns);
        for (i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            Column col = (Column)columnMap.get(name);
            if (col == null) {
                if (newColumnNames.contains(name)) {
                    throw new ColumnAlreadyDefinedException("The column '" + name + "' was specified in the given column order list more than once.");
                }
                throw new ColumnNotDefinedException("The column '" + name + "', specified in the given column order list does not exist.");
            }
            newColumns.add(col);
            newColumnNames.add(name);
            columnMap.remove(name);
        }
        if (columnMap.size() > 0) {
            Column[] rest = new Column[columnMap.size()];
            int idx = 0;
            Iterator iterRest = columnMap.entrySet().iterator();
            while (iterRest.hasNext()) {
                rest[idx] = (Column)iterRest.next().getValue();
                ++idx;
            }
            Arrays.sort(rest, new Comparator(){

                public int compare(Object a, Object b) {
                    int idxB;
                    int idxA = ((Column)a).getIndex();
                    if (idxA > (idxB = ((Column)b).getIndex())) {
                        return 1;
                    }
                    if (idxA < idxB) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (int i2 = 0; i2 < rest.length; ++i2) {
                Column col = rest[i2];
                newColumns.add(col);
            }
        }
        for (i = 0; i < numColumns; ++i) {
            Column col = (Column)newColumns.get(i);
            col.setIndex(i);
        }
        this.columns = newColumns;
    }

    public Column[] getVisibleColumns() {
        int numColumns = this.getColumnCount();
        Column[] columns = new Column[numColumns];
        int idx = 0;
        try {
            for (int i = 0; i < numColumns; ++i) {
                Column column = this.getColumn(i);
                LayoutHints layoutHints = column.getLayoutHints();
                if (layoutHints == null || !layoutHints.isVisible()) continue;
                columns[idx] = column;
                ++idx;
            }
        }
        catch (ColumnNotDefinedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        Column[] visibleColumns = new Column[idx];
        if (idx > 0) {
            System.arraycopy(columns, 0, visibleColumns, 0, idx);
        }
        return visibleColumns;
    }

    public Column[] getVisibleColumns(int levelFilter) {
        int numColumns = this.getColumnCount();
        Column[] columns = new Column[numColumns];
        int idx = 0;
        try {
            for (int i = 0; i < numColumns; ++i) {
                Column column = this.getColumn(i);
                LayoutHints layoutHints = column.getLayoutHints();
                if (layoutHints == null || !layoutHints.isVisible() || levelFilter >= 0 && layoutHints.getLevel() > levelFilter) continue;
                columns[idx] = column;
                ++idx;
            }
        }
        catch (ColumnNotDefinedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        Column[] visibleColumns = new Column[idx];
        if (idx > 0) {
            System.arraycopy(columns, 0, visibleColumns, 0, idx);
        }
        return visibleColumns;
    }

    public Table copyTable() throws TableException {
        DataTable copy = new DataTable(this.getFormatHelper());
        int numColumns = this.getColumnCount();
        for (int i = 0; i < numColumns; ++i) {
            Column col = this.getColumn(i);
            copy.addColumn(col.getName(), col.getType()).setFormat(col.getFormat()).setLayoutHints(col.getLayoutHints()).setKey(col.isKey()).setAlias(col.getAlias()).setDataIndex(col.getDataIndex());
        }
        Iterator iterRows = this.iterator();
        while (iterRows.hasNext()) {
            Row row = (Row)iterRows.next();
            copy.addRow(row);
        }
        return copy;
    }

    public Set getDistinctValues(int columnIdx) throws TableException {
        HashSet<Object> distinctValues = new HashSet<Object>();
        Iterator iterRows = this.iterator();
        while (iterRows.hasNext()) {
            Row row = (Row)iterRows.next();
            distinctValues.add(row.getObject(columnIdx));
        }
        return distinctValues;
    }

    public Set getDistinctValues(String columnName) throws TableException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getDistinctValues(columnIdx);
    }

    protected void writeData(ObjectOutputStream s) throws IOException {
        s.writeObject(this.formatHelper);
        s.writeObject(this.columns);
        s.writeObject(this.columnMap);
    }

    protected void readData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.formatHelper = (FormatHelper)s.readObject();
        this.columns = (List)s.readObject();
        this.columnMap = (Map)s.readObject();
    }
}

