/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import org.ujac.util.BeanUtils;
import org.ujac.util.table.BaseRow;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableConstants;
import org.ujac.util.table.TypeMismatchException;

public class DataRow
extends BaseRow
implements TableConstants,
Row {
    static final long serialVersionUID = -8435793368278149790L;
    private int row = -1;
    private String type = "normal";

    protected DataRow(Table table, int rowIdx) {
        super(table);
        this.row = rowIdx;
    }

    public DataRow(Table table, int rowIdx, Row srcRow) {
        super(table, srcRow);
        this.row = rowIdx;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Table getTable() {
        return this.table;
    }

    public int getIndex() {
        return this.row;
    }

    protected void setIndex(int index) {
        this.row = index;
    }

    protected void expandRow() {
        int elementCount;
        int columnCount = this.table.getColumnCount();
        for (int i = elementCount = this.rowData.size(); i < columnCount; ++i) {
            this.rowData.add(null);
        }
    }

    protected void removeColumn(int columnIdx) throws ColumnNotDefinedException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        this.rowData.remove(dataIdx);
    }

    public String getString(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getString(column.getIndex());
    }

    public String getString(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return null;
        }
        Format fmt = this.getFormat(column.getName());
        switch (column.getType()) {
            case 1: {
                if (fmt != null && !(value instanceof String)) {
                    return fmt.format(value);
                }
                return value.toString();
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (fmt != null) {
                    return fmt.format(value);
                }
                return value.toString();
            }
            case 11: {
                if (fmt != null) {
                    return fmt.format(value);
                }
                return value.toString();
            }
        }
        throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to String.");
    }

    public void setString(String columnName, String value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setString(column.getIndex(), value);
    }

    public void setString(int columnIdx, String value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        if (value == null) {
            this.rowData.set(dataIdx, null);
        }
        switch (column.getType()) {
            case 1: 
            case 11: {
                this.rowData.set(dataIdx, value);
                break;
            }
            case 8: {
                try {
                    this.rowData.set(dataIdx, this.getFormat(column.getName()).parseObject(value));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse date value from String '" + value + "'.");
                }
            }
            case 9: {
                try {
                    this.rowData.set(dataIdx, this.getFormat(column.getName()).parseObject(value));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse date value from String '" + value + "'.");
                }
            }
            case 10: {
                try {
                    this.rowData.set(dataIdx, this.getFormat(column.getName()).parseObject(value));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse date value from String '" + value + "'.");
                }
            }
            case 2: {
                try {
                    NumberFormat fmt = (NumberFormat)this.getFormat(column.getName());
                    if (fmt != null) {
                        this.rowData.set(dataIdx, fmt.parseObject(value));
                        break;
                    }
                    this.rowData.set(dataIdx, new Integer(value));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse integer value from String '" + value + "'.");
                }
            }
            case 4: {
                try {
                    NumberFormat fmt = (NumberFormat)this.getFormat(column.getName());
                    if (fmt != null) {
                        this.rowData.set(dataIdx, fmt.parseObject(value));
                        break;
                    }
                    this.rowData.set(dataIdx, new Long(value));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse long value from String '" + value + "'.");
                }
            }
            case 5: {
                try {
                    NumberFormat fmt = (NumberFormat)this.getFormat(column.getName());
                    if (fmt != null) {
                        this.rowData.set(dataIdx, fmt.parseObject(value));
                        break;
                    }
                    this.rowData.set(dataIdx, new Float(value));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse float value from String '" + value + "'.");
                }
            }
            case 6: {
                try {
                    NumberFormat fmt = (NumberFormat)this.getFormat(column.getName());
                    if (fmt != null) {
                        this.rowData.set(dataIdx, fmt.parseObject(value));
                        break;
                    }
                    this.rowData.set(dataIdx, new Double(value));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse double value from String '" + value + "'.");
                }
            }
            default: {
                throw new TypeMismatchException("Unable to write String value to row type " + column.getTypeName() + ".");
            }
        }
    }

    public int getInt(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getInt(column.getIndex());
    }

    public int getInt(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return 0;
        }
        if (column.getType() != 2) {
            throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to int.");
        }
        return ((Number)value).intValue();
    }

    public void setInt(String columnName, int value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setInt(column.getIndex(), value);
    }

    public void setInt(int columnIdx, int value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        switch (column.getType()) {
            default: 
        }
        Integer integerVal = new Integer(value);
        this.rowData.set(dataIdx, integerVal);
    }

    public long getLong(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getLong(column.getIndex());
    }

    public long getLong(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return 0L;
        }
        switch (column.getType()) {
            case 4: {
                return ((Number)value).longValue();
            }
            case 2: {
                return ((Number)value).longValue();
            }
        }
        throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to long.");
    }

    public void setLong(String columnName, long value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setLong(column.getIndex(), value);
    }

    public void setLong(int columnIdx, long value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        switch (column.getType()) {
            default: 
        }
        Long longVal = new Long(value);
        this.rowData.set(dataIdx, longVal);
    }

    public float getFloat(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getFloat(column.getIndex());
    }

    public float getFloat(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return Float.NaN;
        }
        switch (column.getType()) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return ((Number)value).floatValue();
            }
        }
        throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to double.");
    }

    public void setFloat(String columnName, float value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setDouble(column.getIndex(), (double)value);
    }

    public void setFloat(int columnIdx, float value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        switch (column.getType()) {
            default: 
        }
        Double doubleVal = new Double(value);
        this.rowData.set(dataIdx, doubleVal);
    }

    public double getDouble(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getDouble(column.getIndex());
    }

    public double getDouble(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return Double.NaN;
        }
        switch (column.getType()) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return ((Number)value).doubleValue();
            }
        }
        throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to double.");
    }

    public void setDouble(String columnName, double value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setDouble(column.getIndex(), value);
    }

    public void setDouble(int columnIdx, double value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        switch (column.getType()) {
            default: 
        }
        Double doubleVal = new Double(value);
        this.rowData.set(dataIdx, doubleVal);
    }

    public boolean getBoolean(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getBoolean(column.getIndex());
    }

    public boolean getBoolean(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return false;
        }
        switch (column.getType()) {
            case 7: {
                return (Boolean)value;
            }
            case 2: {
                return ((Number)value).intValue() > 0;
            }
            case 4: {
                return ((Number)value).longValue() > 0L;
            }
            case 1: {
                String strVal = (String)value;
                return strVal.equalsIgnoreCase("true") || strVal.equalsIgnoreCase("y") || strVal.equalsIgnoreCase("j");
            }
            case 11: {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                return new Boolean(value.toString());
            }
        }
        throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to boolean.");
    }

    public void setBoolean(String columnName, boolean value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setBoolean(column.getIndex(), value);
    }

    public void setBoolean(int columnIdx, boolean value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        switch (column.getType()) {
            case 7: 
            case 11: {
                Boolean boolVal = value ? Boolean.TRUE : Boolean.FALSE;
                this.rowData.set(dataIdx, boolVal);
                break;
            }
            case 2: {
                Integer intVal = value ? new Integer(1) : new Integer(0);
                this.rowData.set(dataIdx, intVal);
                break;
            }
            case 4: {
                Long longVal = value ? new Long(1L) : new Long(0L);
                this.rowData.set(dataIdx, longVal);
                break;
            }
            case 1: {
                String strVal = new Boolean(value).toString();
                this.rowData.set(dataIdx, strVal);
                break;
            }
            default: {
                throw new TypeMismatchException("Unable write boolean value to row type " + column.getTypeName() + ".");
            }
        }
    }

    public Date getDate(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getDate(column.getIndex());
    }

    public Date getDate(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return null;
        }
        switch (column.getType()) {
            case 8: 
            case 9: 
            case 10: {
                return (Date)value;
            }
            case 1: {
                try {
                    return (Date)this.getFormat(column.getName()).parseObject((String)value);
                }
                catch (ParseException e) {
                    throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Date: " + e.getMessage());
                }
            }
            case 11: {
                if (value instanceof Date) {
                    return (Date)value;
                }
                try {
                    return (Date)this.getFormat(column.getName()).parseObject(value.toString());
                }
                catch (ParseException e) {
                    throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Date: " + e.getMessage());
                }
            }
        }
        throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Date.");
    }

    public void setDate(String columnName, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setDate(column.getIndex(), value);
    }

    public void setDate(int columnIdx, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        if (value == null) {
            this.rowData.set(dataIdx, null);
        }
        switch (column.getType()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.rowData.set(dataIdx, value);
                break;
            }
            case 1: {
                DateFormat fmt = (DateFormat)this.getFormat(column.getName());
                String strVal = null;
                strVal = fmt != null ? fmt.format(value) : value.toString();
                this.rowData.set(dataIdx, strVal);
                break;
            }
            default: {
                throw new TypeMismatchException("Unable write Date value to row type " + column.getTypeName() + ".");
            }
        }
    }

    public Date getTime(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getTime(column.getIndex());
    }

    public Date getTime(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return null;
        }
        switch (column.getType()) {
            case 8: 
            case 9: 
            case 10: {
                return (Date)value;
            }
            case 1: {
                try {
                    return (Date)this.getFormat(column.getName()).parseObject((String)value);
                }
                catch (ParseException e) {
                    throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Time: " + e.getMessage());
                }
            }
            case 11: {
                if (value instanceof Date) {
                    return (Date)value;
                }
                try {
                    return (Date)this.getFormat(column.getName()).parseObject(value.toString());
                }
                catch (ParseException e) {
                    throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Time: " + e.getMessage());
                }
            }
        }
        throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Date.");
    }

    public void setTime(String columnName, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setTime(column.getIndex(), value);
    }

    public void setTime(int columnIdx, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        if (value == null) {
            this.rowData.set(dataIdx, null);
        }
        switch (column.getType()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.rowData.set(dataIdx, value);
                break;
            }
            case 1: {
                DateFormat fmt = (DateFormat)this.getFormat(column.getName());
                String strVal = null;
                strVal = fmt != null ? fmt.format(value) : value.toString();
                this.rowData.set(dataIdx, strVal);
                break;
            }
            default: {
                throw new TypeMismatchException("Unable write Time value to row type " + column.getTypeName() + ".");
            }
        }
    }

    public Date getTimestamp(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getTimestamp(column.getIndex());
    }

    public Date getTimestamp(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return null;
        }
        switch (column.getType()) {
            case 8: 
            case 9: 
            case 10: {
                return (Date)value;
            }
            case 1: {
                try {
                    return (Date)this.getFormat(column.getName()).parseObject((String)value);
                }
                catch (ParseException e) {
                    throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Date: " + e.getMessage());
                }
            }
            case 11: {
                if (value instanceof Date) {
                    return (Date)value;
                }
                try {
                    return (Date)this.getFormat(column.getName()).parseObject(value.toString());
                }
                catch (ParseException e) {
                    throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Date: " + e.getMessage());
                }
            }
        }
        throw new TypeMismatchException("Unable to convert a variable of type " + column.getTypeName() + " to Date.");
    }

    public void setTimestamp(String columnName, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setTimestamp(column.getIndex(), value);
    }

    public void setTimestamp(int columnIdx, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        if (value == null) {
            this.rowData.set(dataIdx, null);
        }
        switch (column.getType()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.rowData.set(dataIdx, value);
                break;
            }
            case 1: {
                DateFormat fmt = (DateFormat)this.getFormat(column.getName());
                String strVal = null;
                strVal = fmt != null ? fmt.format(value) : value.toString();
                this.rowData.set(dataIdx, strVal);
                break;
            }
            default: {
                throw new TypeMismatchException("Unable write Timestamp value to row type " + column.getTypeName() + ".");
            }
        }
    }

    public Object getObject(String columnName) throws ColumnNotDefinedException {
        Column column = this.table.getColumn(columnName);
        return this.getObject(column.getIndex());
    }

    public Object getObject(int columnIdx) throws ColumnNotDefinedException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        Object value = this.rowData.get(dataIdx);
        if (value == null) {
            return null;
        }
        return value;
    }

    public void setObject(String columnName, Object value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setObject(column.getIndex(), value);
    }

    public void setObject(int columnIdx, Object value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        if (value == null) {
            this.rowData.set(dataIdx, null);
            return;
        }
        switch (column.getType()) {
            case 1: {
                this.rowData.set(dataIdx, value.toString());
                break;
            }
            case 8: {
                try {
                    if (value instanceof Date) {
                        this.rowData.set(dataIdx, value);
                        break;
                    }
                    String strValue = value.toString();
                    if (BeanUtils.isEmpty(strValue)) {
                        this.rowData.set(dataIdx, null);
                        break;
                    }
                    this.rowData.set(dataIdx, this.getFormat(column.getName()).parseObject(strValue));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse date value from Object '" + value + "'.");
                }
            }
            case 9: {
                try {
                    if (value instanceof Date) {
                        this.rowData.set(dataIdx, value);
                        break;
                    }
                    String strValue = value.toString();
                    if (BeanUtils.isEmpty(strValue)) {
                        this.rowData.set(dataIdx, null);
                        break;
                    }
                    this.rowData.set(dataIdx, this.getFormat(column.getName()).parseObject(strValue));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse date value from Object '" + value + "'.");
                }
            }
            case 10: {
                try {
                    if (value instanceof Date) {
                        this.rowData.set(dataIdx, value);
                        break;
                    }
                    String strValue = value.toString();
                    if (BeanUtils.isEmpty(strValue)) {
                        this.rowData.set(dataIdx, null);
                        break;
                    }
                    this.rowData.set(dataIdx, this.getFormat(column.getName()).parseObject(strValue));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse date value from Object '" + value + "'.");
                }
            }
            case 2: {
                try {
                    NumberFormat fmt = (NumberFormat)this.getFormat(column.getName());
                    if (value instanceof Number) {
                        this.rowData.set(dataIdx, value);
                        break;
                    }
                    String strValue = value.toString();
                    if (BeanUtils.isEmpty(strValue)) {
                        this.rowData.set(dataIdx, null);
                        break;
                    }
                    if (fmt != null) {
                        this.rowData.set(dataIdx, fmt.parseObject(strValue));
                        break;
                    }
                    this.rowData.set(dataIdx, new Integer(strValue));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse integer value from Object '" + value + "'.");
                }
            }
            case 4: {
                try {
                    NumberFormat fmt = (NumberFormat)this.getFormat(column.getName());
                    if (value instanceof Number) {
                        this.rowData.set(dataIdx, value);
                        break;
                    }
                    String strValue = value.toString();
                    if (BeanUtils.isEmpty(strValue)) {
                        this.rowData.set(dataIdx, null);
                        break;
                    }
                    if (fmt != null) {
                        this.rowData.set(dataIdx, fmt.parseObject(strValue));
                        break;
                    }
                    this.rowData.set(dataIdx, new Long(strValue));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse long value from Object '" + value + "'.");
                }
            }
            case 5: {
                try {
                    NumberFormat fmt = (NumberFormat)this.getFormat(column.getName());
                    if (value instanceof Number) {
                        this.rowData.set(dataIdx, value);
                        break;
                    }
                    String strValue = value.toString();
                    if (BeanUtils.isEmpty(strValue)) {
                        this.rowData.set(dataIdx, null);
                        break;
                    }
                    if (fmt != null) {
                        this.rowData.set(dataIdx, fmt.parseObject(strValue));
                        break;
                    }
                    this.rowData.set(dataIdx, new Float(strValue));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse float value from Object '" + value + "'.");
                }
            }
            case 6: {
                try {
                    NumberFormat fmt = (NumberFormat)this.getFormat(column.getName());
                    if (value instanceof Number) {
                        this.rowData.set(dataIdx, value);
                        break;
                    }
                    String strValue = value.toString();
                    if (BeanUtils.isEmpty(strValue)) {
                        this.rowData.set(dataIdx, null);
                        break;
                    }
                    if (fmt != null) {
                        this.rowData.set(dataIdx, fmt.parseObject(strValue));
                        break;
                    }
                    this.rowData.set(dataIdx, new Double(strValue));
                    break;
                }
                catch (ParseException ex) {
                    throw new TypeMismatchException("Unable to parse double value from Object '" + value + "'.");
                }
            }
            case 7: {
                if (value instanceof Boolean) {
                    this.rowData.set(dataIdx, value);
                    break;
                }
                this.rowData.set(dataIdx, new Boolean(value.toString()));
                break;
            }
            case 11: {
                this.rowData.set(dataIdx, value);
                break;
            }
            default: {
                throw new TypeMismatchException("Unable to write Object value to row type " + column.getTypeName() + ".");
            }
        }
    }

    protected void writeData(ObjectOutputStream s) throws IOException {
        super.writeData(s);
        s.writeInt(this.row);
        s.writeObject(this.type);
    }

    protected void readData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        super.readData(s);
        this.row = s.readInt();
        this.type = (String)s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeData(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readData(s);
    }
}

