/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowFilterRule;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;

public class FilteredTableIterator
implements Iterator {
    private Table table = null;
    private RowFilterRule filterRule = null;
    private Iterator tableIterator = null;
    private Row prefetchedRow = null;

    protected FilteredTableIterator(Table table, RowFilterRule filterRule) {
        this.table = table;
        this.filterRule = filterRule;
        this.tableIterator = table.iterator();
        this.prefetchRow();
    }

    public boolean hasNext() {
        return this.prefetchedRow != null;
    }

    public Object next() {
        Row currentRow = this.prefetchedRow;
        if (currentRow == null) {
            throw new NoSuchElementException();
        }
        this.prefetchedRow = null;
        this.prefetchRow();
        return currentRow;
    }

    private void prefetchRow() {
        try {
            while (this.tableIterator.hasNext()) {
                Row row = (Row)this.tableIterator.next();
                if (!this.filterRule.test(row)) continue;
                this.prefetchedRow = row;
                break;
            }
        }
        catch (TableException ex) {
            throw new RuntimeException("Unexpected error while prefetching next valid row.", ex);
        }
    }

    public void remove() {
        throw new IllegalStateException("Removing rows is not permitted for filtered tables!");
    }
}

