/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.util.ArrayList;
import java.util.Iterator;
import org.ujac.util.BeanUtils;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.FunctionExecutor;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;

public class PivotTable
extends DataTable {
    private static final long serialVersionUID = -6469000018376336834L;
    public static final int FUNCTION_SUM = 1;
    public static final int FUNCTION_COUNT = 2;

    public PivotTable(Table dataTable, String[] groupColumns, String columnKey, String dataKey, FunctionExecutor function) throws TableException {
        int numGroupColumns = groupColumns.length;
        int[] srcGroupColumnIdxs = new int[numGroupColumns];
        int[] dstGroupColumnIdxs = new int[numGroupColumns];
        for (int i = 0; i < numGroupColumns; ++i) {
            String colName = groupColumns[i];
            Column col = dataTable.getColumn(colName);
            srcGroupColumnIdxs[i] = col.getIndex();
            dstGroupColumnIdxs[i] = this.addColumn(colName, col.isKey(), col.getType()).setLayoutHints(col.getLayoutHints()).getIndex();
        }
        Column colCol = dataTable.getColumn(columnKey);
        int columnColumnIdx = colCol.getIndex();
        Column dataCol = dataTable.getColumn(dataKey);
        int dataColumnIdx = dataCol.getIndex();
        int sumColumnIdx = -1;
        ArrayList<Number> sumList = new ArrayList<Number>();
        double groupResult = 0.0;
        Object curGroupVal = null;
        Row curRow = null;
        boolean first = true;
        Iterator dataTableIter = dataTable.iterator();
        while (dataTableIter.hasNext()) {
            Row row = (Row)dataTableIter.next();
            Object groupVal = null;
            StringBuffer grpBuf = new StringBuffer();
            for (int i = 0; i < numGroupColumns; ++i) {
                groupVal = row.getObject(srcGroupColumnIdxs[i]);
                grpBuf.append(groupVal).append(";");
            }
            groupVal = grpBuf.toString();
            String colName = row.getString(columnColumnIdx);
            if (first || !BeanUtils.equals(groupVal, curGroupVal)) {
                if (!first) {
                    if (function.integersGuaranteed()) {
                        sumList.add(new Integer((int)groupResult));
                    } else {
                        sumList.add(new Double(groupResult));
                    }
                }
                first = false;
                curGroupVal = groupVal;
                groupResult = 0.0;
                curRow = this.addRow();
                for (int i = 0; i < numGroupColumns; ++i) {
                    groupVal = row.getObject(srcGroupColumnIdxs[i]);
                    curRow.setObject(dstGroupColumnIdxs[i], groupVal);
                }
            }
            Column curCol = null;
            try {
                curCol = this.getColumn(colName);
            }
            catch (ColumnNotDefinedException ex) {
                curCol = function.integersGuaranteed() ? this.addColumn(colName, 2, new LayoutHints(10.0f, colName)) : this.addColumn(colName, 6, new LayoutHints(10.0f, colName));
            }
            Object value = row.getObject(dataColumnIdx);
            groupResult = function.execute(groupResult, value);
            double curVal = curRow.getDouble(curCol.getIndex());
            curVal = function.execute(curVal, value);
            if (function.integersGuaranteed()) {
                curRow.setInt(curCol.getIndex(), (int)curVal);
                continue;
            }
            curRow.setDouble(curCol.getIndex(), curVal);
        }
        if (function.integersGuaranteed()) {
            sumList.add(new Integer((int)groupResult));
        } else {
            sumList.add(new Double(groupResult));
        }
        sumColumnIdx = function.integersGuaranteed() ? this.addColumn("sum", 2, new LayoutHints(10.0f, "Sum")).getIndex() : this.addColumn("sum", 6, new LayoutHints(10.0f, "Sum")).getIndex();
        int numSums = sumList.size();
        for (int i = 0; i < numSums; ++i) {
            Row row = this.getRow(i);
            row.setObject(sumColumnIdx, sumList.get(i));
        }
    }
}

