/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.FunctionExecutor;
import org.ujac.util.table.ReportGroup;
import org.ujac.util.table.ReportTable;
import org.ujac.util.table.TableConstants;
import org.ujac.util.table.TableIterationException;
import org.ujac.util.table.TypeMismatchException;

public class ReportFunction
implements Cloneable,
TableConstants,
Serializable {
    static final long serialVersionUID = -6712139086971422640L;
    private String columnName = null;
    private boolean calculateTotalResult = false;
    private FunctionExecutor executor = null;
    private int columnIdx = -1;
    private ReportTable report = null;
    private double totalResult = 0.0;
    private List groupNames = new ArrayList();
    private ReportGroup[] groups = null;
    private Format format = null;
    private int align = 2;

    public ReportFunction(String columnName, FunctionExecutor executor, boolean calculateTotalResult) {
        this.columnName = columnName;
        this.executor = executor;
        this.calculateTotalResult = calculateTotalResult;
    }

    public ReportFunction(String columnName, FunctionExecutor executor, boolean calculateTotalResult, String[] groups) {
        this.columnName = columnName;
        this.executor = executor;
        this.calculateTotalResult = calculateTotalResult;
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                this.addGroup(groups[i]);
            }
        }
    }

    public ReportFunction(String columnName, FunctionExecutor executor, boolean calculateTotalResult, List groups) {
        this.columnName = columnName;
        this.executor = executor;
        this.calculateTotalResult = calculateTotalResult;
        if (groups != null) {
            int numGroups = groups.size();
            for (int i = 0; i < numGroups; ++i) {
                this.addGroup((String)groups.get(i));
            }
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isCalculateTotalResult() {
        return this.calculateTotalResult;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    protected void setColumnIdx(int columnIdx) {
        this.columnIdx = columnIdx;
    }

    protected FunctionExecutor getExecutor() {
        return this.executor;
    }

    public double getTotalResult() {
        return this.totalResult;
    }

    public void addGroup(String groupName) {
        this.groupNames.add(groupName);
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    protected void init(ReportTable report, ReportGroup[] allGroups) {
        this.report = report;
        this.totalResult = 0.0;
        if (this.columnIdx < 0) {
            try {
                this.columnIdx = report.getColumnIndex(this.columnName);
            }
            catch (ColumnNotDefinedException ex) {
                throw new TableIterationException(ex.getMessage());
            }
        }
        int numGroupNames = this.groupNames.size();
        this.groups = new ReportGroup[numGroupNames];
        int groupIdx = 0;
        for (int i = 0; i < numGroupNames; ++i) {
            String groupName = (String)this.groupNames.get(i);
            ReportGroup group = null;
            for (int j = 0; j < allGroups.length; ++j) {
                group = allGroups[j];
                if (group != null && group.getColumnName().equals(groupName)) {
                    this.groups[groupIdx] = group;
                    ++groupIdx;
                    break;
                }
                group = null;
            }
            if (group != null) continue;
            throw new TableIterationException("Detected undefined group '" + groupName + "'");
        }
        if (this.format == null) {
            if (this.executor.integersGuaranteed()) {
                this.format = report.getDataTable().getFormatHelper().getIntegerFormat();
            } else {
                try {
                    this.format = report.getDataTable().getColumn(this.columnIdx).getFormat();
                    if (this.format == null) {
                        switch (report.getColumn(this.columnIdx).getType()) {
                            case 2: 
                            case 4: {
                                this.format = report.getDataTable().getFormatHelper().getIntegerFormat();
                                break;
                            }
                            case 5: 
                            case 6: {
                                this.format = report.getDataTable().getFormatHelper().getDoubleFormat();
                            }
                        }
                    }
                }
                catch (ColumnNotDefinedException ex) {
                    throw new TableIterationException(ex.getMessage());
                }
            }
        }
    }

    public void apply(Object operand) throws TypeMismatchException {
        if (this.calculateTotalResult) {
            this.totalResult = this.executor.execute(this.totalResult, operand);
        }
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                ReportGroup group = this.groups[i];
                group.applyFunction(this.columnIdx, this.executor, operand);
            }
        }
    }

    protected Object clone() {
        ReportFunction clone = null;
        try {
            clone = (ReportFunction)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone Operand instance: " + ex.getMessage(), ex);
        }
        clone.groupNames = (List)((ArrayList)this.groupNames).clone();
        return clone;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.columnName);
        s.writeBoolean(this.calculateTotalResult);
        s.writeObject(this.executor);
        s.writeInt(this.columnIdx);
        s.writeObject(this.report);
        s.writeDouble(this.totalResult);
        s.writeObject(this.groupNames);
        s.writeObject(this.groups);
        s.writeObject(this.format);
        s.writeInt(this.align);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.columnName = (String)s.readObject();
        this.calculateTotalResult = s.readBoolean();
        this.executor = (FunctionExecutor)s.readObject();
        this.columnIdx = s.readInt();
        this.report = (ReportTable)s.readObject();
        this.totalResult = s.readDouble();
        this.groupNames = (List)s.readObject();
        this.groups = (ReportGroup[])s.readObject();
        this.format = (Format)s.readObject();
        this.align = s.readInt();
    }
}

