/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import org.ujac.util.DefaultTypeConverter;
import org.ujac.util.TypeConverter;
import org.ujac.util.TypeConverterException;
import org.ujac.util.db.DataTypeMapper;
import org.ujac.util.db.DefaultDataTypeMapper;
import org.ujac.util.table.BaseTable;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.CompareItem;
import org.ujac.util.table.DataRow;
import org.ujac.util.table.HeaderRow;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.OperationNotSupportedException;
import org.ujac.util.table.ResultSetTableIterator;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowNotDefinedException;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TypeMismatchException;
import org.ujac.util.text.FormatHelper;

public class ResultSetTable
extends BaseTable {
    private ResultSet resultSet = null;
    private DataTypeMapper dataTypeMapper = null;
    private int currentRowIdx = 0;
    private int currentResultSetRowIdx = 0;
    private Row currentRow = null;

    public ResultSetTable(ResultSet resultSet) throws SQLException, TableException {
        this(resultSet, FormatHelper.createInstance());
    }

    public ResultSetTable(ResultSet resultSet, FormatHelper formatHelper) throws SQLException, TableException {
        this(resultSet, formatHelper, new DefaultDataTypeMapper());
    }

    public ResultSetTable(ResultSet resultSet, FormatHelper formatHelper, DataTypeMapper dataTypeMapper) throws SQLException, TableException {
        super(formatHelper);
        this.resultSet = resultSet;
        this.dataTypeMapper = dataTypeMapper;
        this.init();
    }

    private void init() throws SQLException, TableException {
        ResultSetMetaData rms = this.resultSet.getMetaData();
        int numColumns = rms.getColumnCount();
        for (int i = 1; i <= numColumns; ++i) {
            String name = rms.getColumnName(i);
            String description = rms.getColumnLabel(i);
            int type = rms.getColumnType(i);
            int scale = rms.getScale(i);
            int precision = rms.getPrecision(i);
            int columnType = 0;
            int columnAlign = 0;
            switch (this.dataTypeMapper.getJavaType(type, scale, precision)) {
                case 11: {
                    columnType = 11;
                    columnAlign = 0;
                    break;
                }
                case 2: {
                    columnType = 4;
                    columnAlign = 2;
                    break;
                }
                case 4: {
                    columnType = 4;
                    columnAlign = 2;
                    break;
                }
                case 5: {
                    columnType = 5;
                    columnAlign = 2;
                    break;
                }
                case 6: {
                    columnType = 6;
                    columnAlign = 2;
                    break;
                }
                case 7: {
                    columnType = 7;
                    columnAlign = 0;
                    break;
                }
                case 1: {
                    columnType = 1;
                    columnAlign = 0;
                    break;
                }
                case 8: {
                    columnType = 8;
                    columnAlign = 0;
                    break;
                }
                case 9: {
                    columnType = 9;
                    columnAlign = 0;
                    break;
                }
                case 10: {
                    columnType = 10;
                    columnAlign = 0;
                    break;
                }
                default: {
                    throw new TableException("Unsupported SQL type '" + rms.getColumnTypeName(i) + "' at column '" + name + "'.");
                }
            }
            Column col = super.addColumn(name, columnType);
            LayoutHints lh = new LayoutHints(10.0f, description, columnAlign);
            col.setLayoutHints(lh);
        }
    }

    public Column addColumn(String name, int type) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Column addColumn(String name, int type, LayoutHints layoutHints) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addString(String name, String value) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addInt(String name, int value) throws TableException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addLong(String name, long value) throws TableException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addFloat(String name, float value) throws TableException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addDouble(String name, double value) throws TableException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addBoolean(String name, boolean value) throws TableException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addDate(String name, Date value) throws TableException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addTime(String name, Date value) throws TableException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public Table addTimestamp(String name, Date value) throws TableException {
        throw new OperationNotSupportedException("Adding columns is not allowed for ResultSetTables.");
    }

    public boolean isEmpty() {
        return this.currentRow == null && !this.checkNextRow();
    }

    public int getRowCount() {
        return -1;
    }

    public Row addRow() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Adding rows is not allowed for ResultSetTables.");
    }

    public Row addRow(Row srcRow) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Adding rows is not allowed for ResultSetTables.");
    }

    public Row getRow(int rowIdx) throws RowNotDefinedException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow;
    }

    public void removeRow(int rowIdx) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Removing rows is not allowed for ResultSetTables.");
    }

    public Row getHeaderRow() {
        HeaderRow row = new HeaderRow(this);
        return row;
    }

    public Iterator iterator() {
        return new ResultSetTableIterator(this);
    }

    public String getString(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getString(columnIdx);
    }

    public String getString(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Column col = this.getColumn(columnName);
        return this.getString(rowIdx, col.getIndex());
    }

    public void setString(int rowIdx, int columnIdx, String value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setString(int rowIdx, String columnName, String value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Column col = this.getColumn(columnName);
        this.setString(rowIdx, col.getIndex(), value);
    }

    public int getInt(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getInt(columnIdx);
    }

    public int getInt(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Column col = this.getColumn(columnName);
        return this.getInt(rowIdx, col.getIndex());
    }

    public void setInt(int rowIdx, int columnIdx, int value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setInt(int rowIdx, String columnName, int value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setInt(rowIdx, columnIdx, value);
    }

    public long getLong(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getLong(columnIdx);
    }

    public long getLong(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getLong(rowIdx, columnIdx);
    }

    public void setLong(int rowIdx, int columnIdx, long value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setLong(int rowIdx, String columnName, long value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setLong(rowIdx, columnIdx, value);
    }

    public float getFloat(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getFloat(columnIdx);
    }

    public float getFloat(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getFloat(rowIdx, columnIdx);
    }

    public void setFloat(int rowIdx, int columnIdx, float value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setFloat(int rowIdx, String columnName, float value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setFloat(rowIdx, columnIdx, value);
    }

    public double getDouble(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getDouble(columnIdx);
    }

    public double getDouble(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getDouble(rowIdx, columnIdx);
    }

    public void setDouble(int rowIdx, int columnIdx, double value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setDouble(int rowIdx, String columnName, double value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setDouble(rowIdx, columnIdx, value);
    }

    public boolean getBoolean(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getBoolean(columnIdx);
    }

    public boolean getBoolean(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getBoolean(rowIdx, columnIdx);
    }

    public void setBoolean(int rowIdx, int columnIdx, boolean value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setBoolean(int rowIdx, String columnName, boolean value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setBoolean(rowIdx, columnIdx, value);
    }

    public Date getDate(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getDate(columnIdx);
    }

    public Date getDate(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getDate(rowIdx, columnIdx);
    }

    public void setDate(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setDate(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setDate(rowIdx, columnIdx, value);
    }

    public Date getTime(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getTime(columnIdx);
    }

    public Date getTime(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getDate(rowIdx, columnIdx);
    }

    public void setTime(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setTime(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setTime(rowIdx, columnIdx, value);
    }

    public Date getTimestamp(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getTimestamp(columnIdx);
    }

    public Date getTimestamp(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getTimestamp(rowIdx, columnIdx);
    }

    public void setTimestamp(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setTimestamp(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setDate(rowIdx, columnIdx, value);
    }

    public Object getObject(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException {
        this.setCurrentRow(rowIdx + 1);
        return this.currentRow.getObject(columnIdx);
    }

    public Object getObject(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getObject(rowIdx, columnIdx);
    }

    public void setObject(int rowIdx, int columnIdx, Object value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        throw new RuntimeException("Manipulating values is not allowed for ResultSetTables.");
    }

    public void setObject(int rowIdx, String columnName, Object value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setObject(rowIdx, columnIdx, value);
    }

    protected boolean checkNextRow() {
        if (this.currentRowIdx == this.currentResultSetRowIdx) {
            try {
                if (!this.resultSet.next()) {
                    return false;
                }
            }
            catch (SQLException ex) {
                return false;
            }
            ++this.currentResultSetRowIdx;
        }
        return true;
    }

    private void setCurrentRow(int rowIdx) throws RowNotDefinedException {
        if (rowIdx == this.currentRowIdx) {
            return;
        }
        try {
            int resultSetDelta = rowIdx - this.currentResultSetRowIdx;
            if (resultSetDelta == 1 ? !this.resultSet.next() : resultSetDelta > 0 && !this.resultSet.relative(resultSetDelta)) {
                throw new RowNotDefinedException("No more rows available: moving to row #" + rowIdx + " failed.");
            }
            this.currentResultSetRowIdx = rowIdx;
            this.currentRowIdx = rowIdx;
            TypeConverter typeConverter = this.getTypeConverter();
            this.currentRow = new DataRow((Table)this, rowIdx - 1);
            int numColumns = this.getColumnCount();
            Object value = null;
            for (int i = 0; i < numColumns; ++i) {
                Column col = this.getColumn(i);
                value = this.resultSet.getObject(col.getDataIndex() + 1);
                if (typeConverter != null) {
                    value = typeConverter.convertObject(col.getType(), value);
                }
                this.currentRow.setObject(i, value);
            }
            this.currentRowIdx = rowIdx;
        }
        catch (SQLException ex) {
            throw new RowNotDefinedException("No more rows available: " + ex.getMessage());
        }
        catch (TypeConverterException ex) {
            throw new RowNotDefinedException("TypeConversion failed: " + ex.getMessage(), ex);
        }
        catch (TableException ex) {
            throw new RowNotDefinedException("No more rows available: " + ex.getMessage());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int numCols = this.getColumnCount();
        try {
            Column col;
            int i;
            int totalWidth = 1;
            int[] widths = new int[numCols];
            for (i = 0; i < numCols; ++i) {
                col = (Column)this.columns.get(i);
                widths[i] = this.computeColumnWidth(i, col);
                totalWidth += widths[i] + 1;
            }
            for (i = 0; i < totalWidth; ++i) {
                buf.append('-');
            }
            buf.append("\n|");
            for (i = 0; i < numCols; ++i) {
                if (i > 0) {
                    buf.append('|');
                }
                col = (Column)this.columns.get(i);
                this.printField(buf, col.getName() + ":" + col.getTypeName(), widths[i]);
            }
            buf.append("|\n");
            for (int k = 0; k < totalWidth; ++k) {
                buf.append('-');
            }
            buf.append('\n');
            int numRows = this.getRowCount();
            for (int row = 0; row < numRows; ++row) {
                if (row > 0) {
                    buf.append('\n');
                }
                buf.append('|');
                for (int j = 0; j < numCols; ++j) {
                    if (j > 0) {
                        buf.append('|');
                    }
                    this.printField(buf, this.getString(row, j), widths[j]);
                }
                buf.append('|');
            }
            buf.append('\n');
            for (int k = 0; k < totalWidth; ++k) {
                buf.append('-');
            }
        }
        catch (RowNotDefinedException e) {
            e.printStackTrace();
        }
        catch (ColumnNotDefinedException e) {
            e.printStackTrace();
        }
        catch (TypeMismatchException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    private int computeColumnWidth(int colId, Column col) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int width = col.getName().length() + col.getTypeName().length() + 1;
        int numRows = this.getRowCount();
        String val = null;
        int valLength = 0;
        for (int row = 0; row < numRows; ++row) {
            val = this.getString(row, colId);
            if (val == null) continue;
            valLength = val.length();
            width = valLength > width ? valLength : width;
        }
        return width;
    }

    private void printField(StringBuffer buf, String value, int columnWidth) {
        buf.append(value);
        int len = 0;
        len = value != null ? value.length() : 4;
        if (len >= columnWidth) {
            return;
        }
        for (int i = len; i < columnWidth; ++i) {
            buf.append(' ');
        }
    }

    public void sort(CompareItem[] compareColumns) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Sorting tables is not allowed for ResultSetTables.");
    }

    public void sort(int columnIdx, int direction) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Sorting tables is not allowed for ResultSetTables.");
    }

    public void setColumnType(int columnIdx, int typeId) throws ColumnNotDefinedException, TypeConverterException {
        Column column = this.getColumn(columnIdx);
        int oldType = column.getType();
        if (oldType == typeId) {
            return;
        }
        column.setType(typeId);
        if (this.getTypeConverter() == null) {
            this.setTypeConverter(new DefaultTypeConverter());
        }
    }

    public void setColumnType(String columnName, int typeId) throws ColumnNotDefinedException, TypeConverterException {
        Column column = this.getColumn(columnName);
        this.setColumnType(column.getIndex(), typeId);
    }
}

