/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.util.Comparator;
import org.ujac.util.table.CompareItem;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;

public class RowComparator
implements Comparator {
    private CompareItem[] compareColumns;

    public RowComparator(CompareItem[] compareColumns) {
        this.compareColumns = compareColumns;
    }

    public int compare(Object a, Object b) throws ClassCastException {
        Row rowA = (Row)a;
        Row rowB = (Row)b;
        for (int i = 0; i < this.compareColumns.length; ++i) {
            CompareItem item = this.compareColumns[i];
            int columnIdx = item.getColumn();
            int direction = item.getDirection();
            int cr = 0;
            try {
                Object objA = rowA.getObject(columnIdx);
                Object objB = rowB.getObject(columnIdx);
                cr = ((Comparable)objA).compareTo(objB);
            }
            catch (TableException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            if (cr == 0) continue;
            if (direction == 2) {
                cr *= -1;
            }
            return cr;
        }
        return 0;
    }
}

