/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.Writer;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public abstract class BaseConditionToken
extends TemplateTokenContainer {
    public int parseArguments() throws StatementException {
        String tokenName = this.getTokenName();
        if (tokenName == null) {
            return this.position;
        }
        int curPos = this.position + tokenName.length() + 2;
        int endPos = this.position + this.getLength();
        char[] source = this.source;
        boolean inside = false;
        int argStart = -1;
        block6: for (int i = curPos; i <= endPos; ++i) {
            char c = source[i];
            switch (c) {
                case '(': {
                    inside = true;
                    continue block6;
                }
                case ')': {
                    if (inside) {
                        if (argStart != -1) {
                            StringBuffer eb = new StringBuffer("${").append(source, argStart, i - argStart).append("}");
                            try {
                                ExpressionTuple et = this.interpreter.parseExpr(eb.toString());
                                this.setArgument(et, 0);
                                argStart = -1;
                            }
                            catch (ExpressionException ex) {
                                throw new StatementException("Syntax error at position " + i + ": invalid condition statement.", ex);
                            }
                        }
                        return i;
                    }
                    throw new StatementException("Syntax error at position " + i + ": unbalanced parethesis.");
                }
                default: {
                    if (Character.isWhitespace(c) || argStart >= 0) continue block6;
                    argStart = i;
                }
            }
        }
        throw new StatementException("Syntax error at position " + endPos + ": unbalanced parethesis.");
    }

    public void execute(Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        if (this.isTrue(ctx)) {
            int numTokens = this.getTokenCount();
            for (int i = 0; i < numTokens; ++i) {
                TemplateToken subToken = this.getToken(i);
                subToken.execute(writer, ctx);
            }
        }
    }

    public abstract boolean isTrue(TemplateContext var1) throws ExpressionException;

    public boolean isResolved() {
        return this.getRootCondition().isResolved();
    }

    public void setResolved(boolean resolved) {
        this.getRootCondition().setResolved(resolved);
    }

    protected BaseConditionToken getPreviousCondition() throws StatementException {
        TemplateTokenContainer parent = this.getParent();
        int numParentChilds = parent.getTokenCount();
        if (numParentChilds < 2) {
            throw new StatementException("The _" + this.getTokenName() + "_ statement must directly follow a condition statement!");
        }
        try {
            TemplateToken token = parent.getToken(numParentChilds - 2);
            return (BaseConditionToken)token;
        }
        catch (ClassCastException ex) {
            throw new StatementException("The _" + this.getTokenName() + "_ statement must directly follow a condition statement!");
        }
    }

    public abstract BaseConditionToken getRootCondition();
}

