/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.ExpressionToken;
import org.ujac.util.template.StaticToken;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateRoot;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public class DefaultTemplateInterpreter
extends BaseTemplateInterpreter {
    public DefaultTemplateInterpreter() {
    }

    public DefaultTemplateInterpreter(ExpressionInterpreter exi) {
        super(exi);
    }

    public TemplateRoot parse(String source) throws TemplateException, IOException {
        if (source == null) {
            return null;
        }
        char[] code = source.toCharArray();
        return this.parse(code);
    }

    public TemplateRoot parse(char[] source) throws TemplateException, IOException {
        TemplateRoot root = new TemplateRoot(source, 0, source.length);
        this.parse(root);
        return root;
    }

    public int parse(TemplateTokenContainer tokenContainer) throws TemplateException, IOException {
        char[] source = tokenContainer.getSource();
        int pos = tokenContainer.getPosition();
        int length = tokenContainer.getLength();
        int maxPos = pos + length;
        int staticStart = -1;
        block8: for (int i = tokenContainer.getBodyStart(); i < maxPos; ++i) {
            char c = source[i];
            switch (c) {
                case '_': {
                    StaticToken st;
                    block9: for (int ti = i + 1; ti < maxPos; ++ti) {
                        c = source[ti];
                        switch (c) {
                            case '_': {
                                String stn;
                                if (staticStart >= 0) {
                                    st = new StaticToken(this, source, staticStart, i - staticStart);
                                    tokenContainer.addToken(st);
                                    staticStart = -1;
                                }
                                if ((stn = new String(source, i + 1, ti - i - 1)).length() == 0) {
                                    StaticToken st2 = new StaticToken(this, source, i, 1);
                                    tokenContainer.addToken(st2);
                                    staticStart = -1;
                                    continue block8;
                                }
                                TemplateToken tkn = this.createToken(stn);
                                if (tkn == null) {
                                    if (tokenContainer.isLegalAncestor(stn)) {
                                        tokenContainer.close(i, ti);
                                        return ti;
                                    }
                                    staticStart = i;
                                    continue block8;
                                }
                                if (tkn.isBodyToken()) {
                                    if (tokenContainer.isLegalAncestor(tkn)) {
                                        tokenContainer.close(i, ti);
                                        tokenContainer.getParent().addToken(tkn);
                                    } else {
                                        tokenContainer.addToken(tkn);
                                    }
                                    tkn.initialize(this, source, i, maxPos - i);
                                    TemplateTokenContainer bodyToken = (TemplateTokenContainer)tkn;
                                    i = this.parse(bodyToken);
                                    if (!tokenContainer.isClosed()) continue block8;
                                    return i;
                                }
                                tokenContainer.addToken(tkn);
                                tkn.initialize(this, source, i, maxPos - i);
                                i = tkn.getEndPosition();
                                continue block8;
                            }
                            case '$': {
                                continue block9;
                            }
                            default: {
                                if (!Character.isWhitespace(c)) continue block9;
                            }
                        }
                    }
                    continue block8;
                }
                case '$': {
                    StaticToken st;
                    if (source.length > i + 1 && source[i + 1] == '{') {
                        int nextPos;
                        if (staticStart >= 0) {
                            StaticToken st3 = new StaticToken(this, source, staticStart, i - staticStart);
                            tokenContainer.addToken(st3);
                            staticStart = -1;
                        }
                        if (this.expressionFilter != null && (nextPos = this.expressionFilter.filterExpression(source, i, maxPos)) > 0) {
                            st = new StaticToken(this, source, i, nextPos - i);
                            tokenContainer.addToken(st);
                            staticStart = -1;
                            i = nextPos - 1;
                            continue block8;
                        }
                        ExpressionTuple expr = this.parseExpr(source, i, maxPos - 1);
                        tokenContainer.addToken(new ExpressionToken(this, source, i += expr.getRelativePosition() + expr.getLength(), expr.getLength(), expr));
                        continue block8;
                    }
                }
                default: {
                    if (staticStart >= 0) continue block8;
                    staticStart = i;
                }
            }
        }
        if (staticStart >= 0) {
            StaticToken st = new StaticToken(this, source, staticStart, maxPos - staticStart);
            tokenContainer.addToken(st);
            staticStart = -1;
        }
        return tokenContainer.getEndPosition();
    }

    public String execute(String template, TemplateContext ctx) throws TemplateException {
        try {
            TemplateRoot templateRoot = this.parse(template);
            if (templateRoot == null) {
                return null;
            }
            StringWriter writer = new StringWriter();
            this.execute(templateRoot, (Writer)writer, ctx);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void execute(String template, Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        TemplateRoot templateRoot = this.parse(template);
        this.execute(templateRoot, writer, ctx);
    }

    public void execute(TemplateRoot template, Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        template.execute(writer, ctx);
    }

    public Object clone() {
        DefaultTemplateInterpreter ti = null;
        try {
            ti = (DefaultTemplateInterpreter)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone Operand instance: " + ex.getMessage(), ex);
        }
        return ti;
    }
}

