/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.Writer;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public class ExpressionToken
extends TemplateToken {
    private static final long serialVersionUID = 4051046354594116918L;
    private ExpressionTuple tuple = null;

    public ExpressionToken(BaseTemplateInterpreter interpreter, char[] source, int position, int length, ExpressionTuple tuple) {
        super(source, position, length);
        this.interpreter = interpreter;
        this.tuple = tuple;
    }

    public void setArgument(Operand argument, int idx) {
    }

    public void execute(Writer writer, TemplateContext ctx) throws ExpressionException, IOException {
        String result = this.interpreter.evalStringExpr(this.tuple, ctx);
        if (result != null) {
            writer.write(result);
        }
    }

    public String toString() {
        return this.getIndention() + this.tuple + "\n";
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        ExpressionToken clone = (ExpressionToken)this.clone();
        clone.interpreter = interpreter;
        clone.parent = parent;
        clone.tuple = (ExpressionTuple)this.tuple.clone();
        return clone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
    }
}

