/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.ujac.util.CollectionUtils;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;
import org.ujac.util.template.TokenAncestor;

public class ProcedureToken
extends TemplateTokenContainer {
    private static final long serialVersionUID = 3257291348297135926L;
    public static final TokenAncestor[] ancestorRules = new TokenAncestor[]{new TokenAncestor("endproc")};
    private String name = null;
    private List arguments = null;

    public String getTokenName() {
        return "procedure";
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        String tokenName = this.getTokenName();
        int curPos = position + tokenName.length() + 2;
        int endPos = position + length;
        int nameStart = -1;
        int nameEnd = -1;
        for (int i = curPos; i <= endPos; ++i) {
            char c = source[i];
            if (c == '(') {
                if (nameEnd >= 0) break;
                nameEnd = i - 1;
                break;
            }
            if (Character.isWhitespace(c)) {
                if (nameStart <= 0 || nameEnd >= 0) continue;
                nameEnd = i - 1;
                continue;
            }
            if (nameStart >= 0) continue;
            nameStart = i;
        }
        this.name = new String(source, nameStart, nameEnd - nameStart + 1);
        this.setBodyStart(this.parseArguments(nameEnd + 1) + 1);
        this.procedureRegistry.put(this.getName(), this);
    }

    public String getName() {
        return this.name;
    }

    public TokenAncestor[] getAncestorRules() {
        return ancestorRules;
    }

    public boolean checkContainer(TemplateTokenContainer container) {
        this.procedureRegistry = container.getProcedureRegistry();
        return false;
    }

    public void setArgument(Operand argument, int idx) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        this.arguments.add(argument.getValue());
    }

    public List getArguments() {
        return this.arguments;
    }

    public void execute(Writer writer, TemplateContext ctx) throws ExpressionException, IOException {
        throw new ExpressionException("Use method execute(List, Writer, ExpressionContext) instead!");
    }

    protected void execute(List arguments, Writer writer, TemplateContext ctx) throws IOException, TemplateException {
        List argumentNames;
        TemplateContext procedureCtx = new TemplateContext(ctx);
        int numArguments = arguments.size();
        if (numArguments != (argumentNames = this.getArguments()).size()) {
            throw new ExpressionException("Invalid number of argument list given for call of procedure " + this + ".");
        }
        for (int i = 0; i < numArguments; ++i) {
            procedureCtx.setProperty(argumentNames.get(i), arguments.get(i));
        }
        int numTokens = this.getTokenCount();
        for (int i = 0; i < numTokens; ++i) {
            TemplateToken subToken = this.getToken(i);
            subToken.execute(writer, procedureCtx);
        }
    }

    public String toString() {
        return this.getIndention() + "_procedure_ " + this.getName() + "(" + this.getArgumentsAsString() + ")\n" + super.toString();
    }

    protected String getArgumentsAsString() {
        StringBuffer ab = new StringBuffer();
        int numArguments = this.arguments.size();
        List argumentNames = this.getArguments();
        for (int i = 0; i < numArguments; ++i) {
            if (i > 0) {
                ab.append(", ");
            }
            ab.append(argumentNames.get(i));
        }
        return ab.toString();
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        ProcedureToken clone = (ProcedureToken)this.clone();
        clone.interpreter = interpreter;
        clone.parent = parent;
        int numOperands = CollectionUtils.getSize(clone.arguments);
        for (int i = 0; i < numOperands; ++i) {
            clone.arguments.set(i, ((Operand)clone.arguments.get(i)).clone());
        }
        clone.cloneChildTokens(this.procedureRegistry, this);
        clone.procedureRegistry.put(clone.getName(), this);
        return clone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
    }
}

